/*
  fifo for audioData
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "audioDataArray.h"




AudioDataArray::AudioDataArray(int entries) {

  this->entries=entries;
  fillgrade=0;
  readPos=0;
  writePos=0;

  audioDataArray=new AudioData*[entries];

  int i;
  for(i=0;i<entries;i++) {
    audioDataArray[i]=new AudioData();
  }

  pthread_mutex_init(&writeInMut,NULL);
  pthread_mutex_init(&changeMut,NULL);
  pthread_cond_init(&changeCond,NULL);
  

}

AudioDataArray::~AudioDataArray() {
  int i;
  for(i=0;i<entries;i++) {
    delete audioDataArray[i];
  } 
  delete audioDataArray;
}




void AudioDataArray::lockStampArray() {

  pthread_mutex_lock(&changeMut);
  pthread_mutex_lock(&writeInMut);
  pthread_mutex_unlock(&changeMut);

}


void AudioDataArray::unlockStampArray() {
  pthread_mutex_unlock(&writeInMut); 
}


void AudioDataArray::internalForward() {
  readPos++;
  fillgrade--;
  if (readPos == entries-1) {
    readPos=0;
  }
}



int AudioDataArray::insertAudioData(AudioData* src) {
  lockStampArray();

  int back=true;
  src->copyTo(audioDataArray[writePos]);


  writePos++;
  fillgrade++;
  if (writePos == entries-1) {
    writePos=0;
  }
  if (fillgrade == entries) {
    cout <<" Audiodata::array overfull forward"<<endl;
    internalForward();
    back=false;
  }
  unlockStampArray();
  return back;
}


AudioData* AudioDataArray::readAudioData() {
  return audioDataArray[readPos];
}


int AudioDataArray::getFillgrade() {
  return fillgrade;
}


void AudioDataArray::forward() {
  lockStampArray();
  internalForward();
  unlockStampArray();
}


void AudioDataArray::clear() {
  lockStampArray();
  fillgrade=0;
  readPos=0;
  writePos=0;
  unlockStampArray();
}


