/*
  description for system stream packets.
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __PACKETDESCRIPTION_H
#define __PACKETDESCRIPTION_H

#include <iostream.h>
#include <stdio.h>

class PacketDescription {
 
  double streamTimeStamp;
  double ptsTimeStamp;
  double dtsTimeStamp;
 
  char* data;
  int len;

 public:
  PacketDescription();
  ~PacketDescription();

  void copyTo(PacketDescription* dest);

  double getStreamTimeStamp();
  void setStreamTimeStamp(double streamTimeStamp);

  double getDTSTimeStamp();
  void setDTSTimeStamp(double dtsTimeStamp);

  double getPTSTimeStamp();
  void setPTSTimeStamp(double ptsTimeStamp);

  // data is then owned as is freed in the desctructor
  void setData(char* data);
  char* getData();

  void setLen(int len);
  int getLen();

  void print(char* msg);

};
#endif
