/* Status codes for bit stream i/o operations. */

#ifndef __UTIL_H
#define __UTIL_H

#include "video.h"

#define NO_VID_STREAM (-1)
#define STREAM_UNDERFLOW (-2)
#define OK 1

/* Size increment of extension data buffers. */

#define EXT_BUF_SIZE 1024

/* External declarations for bitstream i/o operations. */
extern unsigned int bitMask[];
extern unsigned int nBitMask[];
extern unsigned int rBitMask[];
extern unsigned int bitTest[];



class Util {

 public:
  Util();
  ~Util();

  static void check_ext_data(MpegPlayBitWindow* input,char* target);
  static int next_bits(int num,unsigned int mask,MpegPlayBitWindow* input);
  static void check_user_data(MpegPlayBitWindow* input,char* target);
  static char *get_extra_bit_info(MpegPlayBitWindow* input);
  static char* get_ext_data (MpegPlayBitWindow* input);

};
#endif
