/*
  reads/parse slice infos
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "slice.h"




Slice::Slice(VidStream* vid_stream) {
  this->vid_stream=vid_stream;
  extra_info=NULL;
}


Slice::~Slice() {
  if (extra_info != NULL) {
    delete extra_info;
  }

}

unsigned int Slice::getVertPos() {
  return vert_pos;
}



void Slice::setQuantScale(unsigned int quant_scale) {
  this->quant_scale=quant_scale;
}

/*
 *--------------------------------------------------------------
 *
 * ParseSlice --
 *
 *      Parses off slice header.
 *
 * Results:
 *      Values found in slice header put into video stream structure.
 *
 * Side effects:
 *      Bit stream irreversibly parsed.
 *
 *--------------------------------------------------------------
 */
int Slice::parseSlice() {
  unsigned int data;
  
  data=(vid_stream->bitwindow)->showBits(32);
  /* Flush slice start code. */
  (vid_stream->bitwindow)->flushBits(24);

  /* Parse off slice vertical position. */

  data=(vid_stream->bitwindow)->getBits(8);

  vert_pos = data;

  /* Parse off quantization scale. */
  data=(vid_stream->bitwindow)->getBits(5);

  quant_scale = data;

  /* Parse off extra bit slice info. */

  if (extra_info != NULL) {
    delete extra_info;
    extra_info = NULL;
  }
  extra_info = Util::get_extra_bit_info(vid_stream->bitwindow);
  return true;
}

  

