/*
  mpeg player plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __MPEGPLUGIN_H
#define __MPEGPLUGIN_H

#include "../playerPlugin/playerPlugin.h"

#include "mpegPlayBitWindow.h"
#include "deMux.h"
#include "proto.h"
#include "mpegLength.h"
#include "sequenceParse.h"

class MpegPlugin : public PlayerPlugin {
  
  MpegLength* mpegLength;
  SequenceParse* sequenceParse;
  SequenceParse* currentSequence;
  
  int lCalcLength;
  int lDoResync;
  
 public:
  MpegPlugin();
  MpegPlugin(SequenceParse* sequenceParse);
  ~MpegPlugin();

  void decoder_loop();
  int seek(int second);
  void config(char* key, char* value);

  SequenceParse* getSequenceInfo();
  void setResync(int lResync);
  int getResync();
  
 private:
  void init(SequenceParse* sequenceParse);

  int getSongLength();
 

};
#endif

