/*
  parses system layer streams.
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <deMux.h>


DeMux::DeMux() {
}


DeMux::~DeMux() {
}



/*
 *--------------------------------------------------------------
 *
 * next_start_code --
 *
 *	Parses off bitstream until start code reached. When done
 *      next 4 bytes of bitstream will be start code. Bit offset
 *      reset to 0.
 *
 * Results:
 *	Status code.
 *
 * Side effects:
 *	Bit stream irreversibly parsed.
 *
 *--------------------------------------------------------------
 */
int DeMux::next_start_code(MpegPlayBitWindow* bitwindow) {


  while(bitwindow->isEof()==false) {
    find_start_code(bitwindow,true);

    if (isStartCode(getStartCode(bitwindow))) {
      return true;
    }
  }
  return false;
}




int DeMux::isStartCode(unsigned int data) {

  switch(data) {
  case SEQ_END_CODE:
  case SEQ_START_CODE:
  case GOP_START_CODE:
  case PICTURE_START_CODE:
  case SLICE_MIN_START_CODE:
  case SLICE_MAX_START_CODE:
  case EXT_START_CODE:
  case USER_START_CODE:
  case SEQUENCE_ERROR_CODE:
  case SYSTEM_HEADER_START_CODE:   
  case ISO_11172_END_CODE:  
  case EOF:  
    return true;
  }
  if ((SLICE_MIN_START_CODE < data) && (data < SLICE_MAX_START_CODE)) {
    return true;
  }
  return false;
}


int DeMux::find_start_code(MpegPlayBitWindow* bitwindow,int flush) {
  bitwindow->flushByteOffset();
  
  unsigned int data;
  data=getStartCode(bitwindow);

  while(bitwindow->isEof()==false) {
    data=getStartCode(bitwindow);
    if (isStartCode(data)) {
      return true;
    }
    bitwindow->flushBits(8);
  }
  return false;
}

unsigned int DeMux::getStartCode(MpegPlayBitWindow* bitwindow) {
  return (bitwindow->showBits(32));
}

int DeMux::skip_to_start_code(MpegPlayBitWindow* bitwindow,unsigned int code) {
  unsigned int data;
  
  bitwindow->flushByteOffset();
  data=getStartCode(bitwindow);
  printf("data:%8x\n",data);

  if(data != code) {
    bitwindow->flushBits(8);
    return false;
  }
  return true;
}





