/*
  generic input class
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "inputStream.h"





InputStream::InputStream() {
  init("input");
}

InputStream::InputStream(char* name) {
  init(name);
}

void InputStream::init(char* name) {
 timeStampArray=new TimeStampArray(name,2000);
 urlBuffer=new DynBuffer(20);
}


InputStream::~InputStream() {
  delete timeStampArray;
  delete urlBuffer;
  
}


int InputStream::open(char* dest) {
  cout << "direct virtual call InputStream::open"<<endl;
  exit(0);
}


void InputStream::close() {
  cout << "direct virtual call InputStream::close"<<endl;
  exit(0); 
}


int InputStream::isOpen() {
  cout << "direct virtual call InputStream::isOpen"<<endl;
  exit(0); 
}


int InputStream::eof() {
  cout << "direct virtual call InputStream::eof"<<endl;
  exit(0);  
}


int InputStream::read(char* ptr,int size) {
  cout << "direct virtual call InputStream::read"<<endl;
  exit(0);  
}


int InputStream::seek(long bytePos) {
  cout << "direct virtual call InputStream::seek"<<endl;
  exit(0);  
}



long InputStream::getByteLength() {
  cout << "direct virtual call InputStream::getByteLength"<<endl;
  exit(0);     
}


long InputStream::getBytePosition() {
  cout << "direct virtual call InputStream::getBytePosition"<<endl;
  exit(0);     
}


void InputStream::insertTimeStamp(TimeStamp* src,long key,int len) {
  timeStampArray->insertTimeStamp(src,key,len);
}

TimeStamp* InputStream::getTimeStamp(long key) {
  return timeStampArray->getTimeStamp(key);
}


int InputStream::bytesUntilNext(long key) {
  return timeStampArray->bytesUntilNext(key);
}

void InputStream::print() {
  cout << "direct virtual call InputStream::print"<<endl;
}



int InputStream::getPath(char* url,char* protocol) {
  int urlLen;
  int protocolLen;
  int back=0;

  if (url == NULL) {
    cout <<"url NULL in getPath"<<endl;
    return 0;
  }
  if (protocol == NULL) {
    cout <<"protocol NULL in getPath"<<endl;
    return 0;
  }
  urlLen=strlen(url);
  protocolLen=strlen(protocol);

  char* cmpString=new char[protocolLen+4];
  strcpy(cmpString,protocol);



  int lHas=false;
  if ((lHas == false) && (urlLen >= protocolLen+3)) {
    cmpString[protocolLen]=':';
    cmpString[protocolLen+1]='/';
    cmpString[protocolLen+2]='/';
    cmpString[protocolLen+3]=(char)0;
    
    if (strncmp(url,cmpString,protocolLen+3)==0) {
      back=protocolLen+2;
      lHas=true;
    }
  } 
  if ((lHas == false) && (urlLen >= protocolLen+2)) {
    cmpString[protocolLen]=':';
    cmpString[protocolLen+1]='/';
    cmpString[protocolLen+2]=(char)0;
   
    if (strncmp(url,cmpString,protocolLen+2)==0) {
      back=protocolLen+1;
      lHas=true;
    }
  }
  if ((lHas == false) && (urlLen >= protocolLen+1)) {
    cmpString[protocolLen]=':';
    cmpString[protocolLen+1]=(char)0;
   
    if (strncmp(url,cmpString,protocolLen+1)==0) {
      back=protocolLen+1;
      lHas=true;
    }
  }  

  return back;
}



char* InputStream::getUrl() {
  return urlBuffer->getData();
}


void InputStream::setUrl(char* url) {
  urlBuffer->clear();
  if (url != NULL) {
    urlBuffer->append(url);
  }
}


