/*
  reads raw input data from cdrom (system dependend)
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "cdromRawAccess.h"



CDRomRawAccess::CDRomRawAccess() {
  cdfile=-1;
  lOpen=false;
  leof=true;
  cdromToc=new CDRomToc();

  buflen=0;
  eofEntry.minute=0;
  eofEntry.second=0;
  eofEntry.frame=0;
}


CDRomRawAccess::~CDRomRawAccess() {
  close();
}



char* CDRomRawAccess::getBufferStart() {
  return buf.data;


}

int CDRomRawAccess::getBufferLen() {
  if (eof()) {
    return 0;
  }
  return buflen;
}

int CDRomRawAccess::open(char* filename) {
  if (isOpen()) {
    close();
  }
  if (filename==NULL) {
    filename=(char*)"/dev/cdrom";
  }
  int matchPos=InputStream::getPath(filename,"cdi");
  cout << "getPath:"<<matchPos<<endl;
  filename+=matchPos;

  if (strlen(filename) <= 1) {
    filename="/dev/cdrom";
  } 
  cout << "open:"<<filename<<endl;
  cdfile=::open(filename, O_RDONLY);
  lOpen=false;

  if (cdfile < 0) {
    perror("open CDRomRawAccess");
  } else {
    lOpen=true;  
    leof=false;
  }
  cout << "readToc -s"<<endl;
  cdromToc->readToc(cdfile);
  cout << "readToc -e"<<endl;
 
  int n=cdromToc->getTocEntries();
  if (n > 0) {
    TocEntry* entry=cdromToc->getTocEntry(n-1);
    eofEntry.minute=entry->minute;
    eofEntry.second=entry->second;
    eofEntry.frame=entry->frame;
  }
  return lOpen;
}


int CDRomRawAccess::eof() {
  return leof;
}


void CDRomRawAccess::close() {
  if (isOpen()) {
    ::close(cdfile);
    lOpen=false;
    leof=true;
    eofEntry.minute=0;
    eofEntry.second=0;
    eofEntry.frame=0;
  }
}

int CDRomRawAccess::isData() {
  if ((buf.subheader[1]==1) && 
      (((buf.subheader[2]==0x62) &&
	(buf.subheader[3]==0x0f)) || ((buf.subheader[2]==0x64) &&
				      (buf.subheader[3]==0x7f)))) {
    return true;
  }

  return false;
}

int CDRomRawAccess::isOpen() {
  return lOpen;
}


int CDRomRawAccess::getTocEntries() {
  return cdromToc->getTocEntries();
}


TocEntry* CDRomRawAccess::getTocEntry(int entry) {
  return cdromToc->getTocEntry(entry);
}
 

void CDRomRawAccess::insertTocEntry(int minute,int second,int frame) {
  cdromToc->insertTocEntry(minute,second,frame);
}


int CDRomRawAccess::getNextTocEntryPos(int minute,int second,int frame) {
  return cdromToc->getNextTocEntryPos(minute,second,frame);
}


void CDRomRawAccess::printToc() {
  cdromToc->print();
}


int CDRomRawAccess::getTimeLength() {
  cdromToc->getEndSecond();
}



