/*
  nice stereo/mono symbolfor KDE Skin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <stereoWidget.h>


StereoWidget::StereoWidget( QWidget *parent=0, const char *name=0 ):
  GuiStereoDevice(parent,name){
  
  led=new LED();
  setBackgroundColor(QColor(0,0,0));
}


StereoWidget::~StereoWidget() {
}


QSize StereoWidget::sizeHint() const {
  QPixmap* pixmap=led->getPixmap(_LED_STEREO);
  int w=pixmap->size().width();
  int h=pixmap->size().height();
  QSize size(w,h);
  return size;
}


void StereoWidget::paintEvent ( QPaintEvent * paintEvent ) {
  QPixmap* pixmapCurrent;
  int stereo;

  stereo=getStereo();
  pixmapCurrent=led->getPixmap(_LED_MONO);   // default pixmap
  
  if (stereo == true) {
    pixmapCurrent=led->getPixmap(_LED_STEREO);
  }
  
  QPainter paint;
  paint.begin( this );
  paint.drawPixmap ( 0, 0, *pixmapCurrent);
  paint.end();  
  

}



