/*
  kdeSkin (Skin, not really, but pluggable)
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __KMPGSKIN_H
#define __KMPGSKIN_H
#include <guiJumpDevice.h>
#include <guiBalanceDevice.h>

#include <guiPlugin.h>

#include <guiBufferInfoDevice.h>
#include <guiSpectrumAnalyser.h>
#include <guiShuffle.h>
#include <guiRepeat.h>
#include <stereoWidget.h>
#include <freqWidget.h>
#include <bpsWidget.h>
#include <yafcore/buffer.h>

#include <timerWidget.h>
#include <statusWidget.h>
#include <infoWidget.h>
#include <controlWidget.h>
#include <volumeWidget.h>

#include <standardGraph.h>
#include <qlayout.h>
#include <preferences.h>
#include <kmpgSkinConfig.h>

#define __SKINID_KMPG       2

/**
   This is the default skin for kmpg. Its a bit ugly, because
   I'm no GUI designer. Maybe you can make look it nicer? 
   Ok. How the things works? Its easy. _Really_ easy.
   The class GuiPlugin defines the signals you can emit.
   In the constructor you build your widgets.
   The underlying api takes care that your skin is attached
   to the multimedia graph.
   You always should derive your new widgets from the correspondig
   basicwidget. The basicwidget offers menus,configurations, but
   only have an ugly paintMethod. This paintmethod is overwritten
   in your "nice" widget.See "infoWidget" for example this
   adds the "yellow 15dot font" and "scrolling" functionality.
*/



class KmpgSkin : public  GuiPlugin {
  Q_OBJECT

 public:
  KmpgSkin(QWidget *parent=0, const char *name=0);
  ~KmpgSkin();
  void attachTo(StandardGraph* standardGraph);
  void detach();
  void configure();
  int  getSkinId();

  void setSong(Song* song);
  void setRepeat(int val);
  void setShuffle(int val);
  void setPlaylist(int val);
  

  QSize sizeHint() const;

 private:
  void setSize();

  // The GUI Objects:
  GuiSpectrumAnalyser* guiSpectrumAnalyser;
  TimerWidget* timerWidget;
  StatusWidget* statusWidget;
  InfoWidget* infoWidget;
  GuiInfoDevice* guiInfoDevice;
  ControlWidget* controlWidget;
  VolumeWidget* volumeWidget;
  GuiBalanceDevice* guiBalanceDevice;
  GuiShuffle* guiShuffle;
  GuiRepeat* guiRepeat;
  StereoWidget* stereoWidget;
  FreqWidget* freqWidget;
  BPSWidget* bpsWidget;
  GuiJumpDevice* guiJumpDevice;
  GuiBufferInfoDevice* guiBufferInfoDevice;


  KmpgSkinConfig* kmpgSkinConfig;
  Preferences* preferences;
};
#endif
