/*
  read wav header
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __WAVFILE_H
#define __WAVFILE_H


#include <iostream.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>

   
typedef struct _waveheader {
  unsigned int     main_chunk;  // 'RIFF'
  unsigned int     length;      // filelen
  unsigned int     chunk_type;  // 'WAVE'

  unsigned int     sub_chunk;   // 'fmt '
  unsigned int     sc_len;      // length of sub_chunk, =16
  unsigned short   format;      // should be 1 for PCM-code
  unsigned short   modus;       // 1 Mono, 2 Stereo
  unsigned int     sample_fq;   // frequence of sample
  unsigned int     byte_p_sec;
  unsigned short   byte_p_spl;  // samplesize; 1 or 2 bytes
  unsigned short   bit_p_spl;   // 8, 12 or 16 bit

  unsigned int     data_chunk;  // 'data'
  unsigned int     data_length; // samplecount
}WAVEHEADER;



class WavFile {

 public:
  WavFile();
  ~WavFile();

  static int getLength(char* filename);

};
#endif
