/*
  read wav header
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <wavFile.h>


WavFile::WavFile() {
}

WavFile::~WavFile() {
}


int WavFile::getLength(char* filename) {
  int back=0;

  if (filename == NULL) {
    return false;
  }
  FILE* file=fopen(filename, "r");
  if (file <= 0) {
    return (0);
  }

  unsigned char *buffer = new unsigned char[sizeof(WAVEHEADER)];
  fseek(file, 0, SEEK_SET);
  int readsize = fread(buffer, 1, sizeof(WAVEHEADER), file);

  if (readsize != sizeof(WAVEHEADER)) {
    delete buffer;
    fclose(file);
    return 0;
  }
  // this will fail on big endian machines
  WAVEHEADER* waveHeader=(WAVEHEADER*) buffer;
  
  struct stat buf;
  
  stat(filename, &buf);
  fclose(file);

  float wavfilesize = (float)buf.st_size;

  int stereo =waveHeader->modus;
  float frequence=(float)waveHeader->sample_fq;
  int bits=waveHeader->bit_p_spl;

  if (bits == 16) {
    wavfilesize=wavfilesize/2;
  }
  if (stereo == 2) {
    wavfilesize=wavfilesize/2;
  }
  if (frequence != 0) {
    back=(int)(wavfilesize/frequence);
  }
  delete buffer;
  return back;
}


