/*
  stores spectrum An. values, in order to have a delayed display
  Copyright (C) 1998  Martin Vogt;Philip VanBaren, 2 September 1993

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __SPECTRUMANALYSERQUEUE_H
#define __SPECTRUMANALYSERQUEUE_H

#include <iostream.h>

#define __MAX_SPAQ_ENTRIES 50


typedef struct {
  int valid;
  int* startPtr;
} SPAQueueEntry;

class SpectrumAnalyserQueue {

  int bands;
  SPAQueueEntry* spaQueueArray[__MAX_SPAQ_ENTRIES];
  int readPos;
  int freePos;
  int fillgrade;

 public:
  SpectrumAnalyserQueue(int bands);
  ~SpectrumAnalyserQueue();

  int* getFreeEntry();        // can be NULL!
  void enqueue();
  void enqueue(int* target,int* source);
  

  int* getNextEntry();        // can be NULL!
  void dequeue();

  int getFillgrade();
  int getBands();
};
#endif
