/*
  abstract menu desription, which is used by popupMenus an menubars
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <menuDescription.h>



MenuDescription::MenuDescription(const char* title) {
  int i;
  this->title=title;

  for(i=0;i<_MAX_MENU_ENTRIES;i++) {
    menuEntryArray[i]=new MenuEntry();
    menuEntryArray[i]->valid=false;
  }
  elements=0;
}


MenuDescription::~MenuDescription() {
  int i;
  for(i=0;i<_MAX_MENU_ENTRIES;i++) {
    delete menuEntryArray[i];
  }
}


char* MenuDescription::getTitle() {
  return (char*)title;
}


void MenuDescription::setTitle(const char* title) {
  this->title=title;
}


void MenuDescription::insertMenu(const char* text,
				 QObject* receiver,const char* signal) {
  int i;
  for(i=0;i<_MAX_MENU_ENTRIES;i++) {
    if (menuEntryArray[i]->valid==false) {
      menuEntryArray[i]->valid=true;
      menuEntryArray[i]->text=(char*)text;
      menuEntryArray[i]->receiver=receiver;
      menuEntryArray[i]->signal=signal;
      elements++;
      return;
    }
  } 
  cout << "menu has too much entries. new entry ignored!"<<endl;
}


int MenuDescription::getElements() {
  return elements;
}


MenuEntry* MenuDescription::getMenu(int pos) {
  return menuEntryArray[pos];
}



KPopupMenu* MenuDescription::createPopupMenu() {
  int i;
  int n;
  MenuEntry* entry;
  KPopupMenu* popupMenu=new KPopupMenu(getTitle());

  n=getElements();
  for(i=0;i<n;i++) {
    entry=getMenu(i);
    popupMenu->insertItem(entry->text,entry->receiver,entry->signal);
  }

  return popupMenu;
}

