/*
  a GUI for a spectrum analyser
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <guiSpectrumAnalyser.h>




GuiSpectrumAnalyser::GuiSpectrumAnalyser( QWidget *parent=0, 
		     const char *name=0):GuiDevice(parent,name) {
  // change this to test (eg : 50)
  spaHeight=15;
  spectrumImage= new SpectrumImage(spaHeight);

  spectrumAnalyserDevice=NULL;
  setBackgroundColor (QColor(0,0,0));
  spectrumAnalyserDeviceConfig=new 
    SpectrumAnalyserDeviceConfig("GuiSpectrumAnalyser",getPreferences());

  getPreferences()->addTab(spectrumAnalyserDeviceConfig,
			   spectrumAnalyserDeviceConfig->getGroupName());
  connect(spectrumAnalyserDeviceConfig,SIGNAL(applyEvent()),
	  this,SLOT(applyEvent()));
  

  insertMenu("Configure",this,SLOT(configure()));
  updateTimer=new QTimer(this);
  connect(updateTimer,SIGNAL(timeout()),this,SLOT(doUpdate()));
}


GuiSpectrumAnalyser::~GuiSpectrumAnalyser() {
  delete spectrumImage;
}


void GuiSpectrumAnalyser::applyEvent() {
  if (spectrumAnalyserDevice == NULL) {
    return;
  } 
  /*
  float percent=spectrumAnalyserDeviceConfig->getFrequencyWindow()/100.0;
  float fftBands=spectrumAnalyserDevice->getFFTBands();
  int startBand=(int)(percent*fftBands);
  
  spectrumAnalyserDevice->setStartBand(startBand);
  */
  int luse=spectrumAnalyserDeviceConfig->getUseSpa();
  if (luse) {
    updateTimer->start(50);
  } else {
    updateTimer->stop();
  }
   

  spectrumAnalyserDevice->setAnalyse(luse);

  spectrumAnalyserDevice->setAnalyseMode(
	spectrumAnalyserDeviceConfig->getAnalyseMode());

}



void GuiSpectrumAnalyser::attachTo(SpectrumAnalyserDevice* 
					 spectrumAnalyserDevice) {

  bands=spectrumAnalyserDevice->getBands();

  pixMap=new QPixmap(bands,spaHeight);
  QColor color(black);
  pixMap->fill(color);
  currentPeaks=new float[bands];
  int i;
  for(i=0;i<bands;i++) {
    currentPeaks[i]=0.0;
  }

  width=bands;
  height=spaHeight;
  setMinimumSize( width, height );
  setMaximumSize( width, height );


  this->spectrumAnalyserDevice=spectrumAnalyserDevice;
  GuiDevice::attachTo(spectrumAnalyserDevice);
  applyEvent();
}


void GuiSpectrumAnalyser::detach() {
  spectrumAnalyserDevice=NULL;
  GuiDevice::detach();
  delete pixMap;
  delete currentPeaks;
}



void GuiSpectrumAnalyser::mousePressEvent ( QMouseEvent* mouseEvent) {
  if (mouseEvent->button() ==  RightButton) {
    KPopupMenu* popupMenu=createPopupMenu();
    popupMenu->move(mapToGlobal(QPoint(mouseEvent->x(),mouseEvent->y())));
    popupMenu->exec();
    delete popupMenu;
  }
}




void GuiSpectrumAnalyser::configure() {
  getPreferences()->show();
}



void GuiSpectrumAnalyser::processEvent(char eventId) {

  switch (eventId) {
  case __SIGNAL_SPECTRUM_ANALYSER_START : {
    updateTimer->start(50);
    break;
  }    
  case __SIGNAL_SPECTRUM_ANALYSER_STOP : {
    updateTimer->stop();
    break;
  }
  default: {
    cout << "unkown event:"<<(int)eventId<<" GuiSpectrumAnalyser"<<endl;
  }
  }
}


QSize GuiSpectrumAnalyser::sizeHint() const {
  QSize size(70,20);
  return size;
}



void GuiSpectrumAnalyser::paintEvent (QPaintEvent * paintEvent) {
  int i;
  float* bandPtr;
  int bands;
  float value;
  QPixmap* peakMap;

  if (spectrumAnalyserDevice == NULL) {
    return;
  }
  bandPtr=spectrumAnalyserDevice->getBandPtr();
  bands=spectrumAnalyserDevice->getBands();
  peakMap=spectrumImage->getPixmap();

  QPainter p;                             // our painter
  p.begin( pixMap );                     // start painting pixmap

  for (i=0;i<bands;i++) {
    value=bandPtr[i];
    // if the peak is less we prefer the higher one
    if (currentPeaks[i] < value) {
      currentPeaks[i]=value;
    } else {
      currentPeaks[i]=currentPeaks[i]-1.3;
    }
    if (currentPeaks[i] < 0) {
      currentPeaks[i]=0;
    }
    if (currentPeaks[i] > spaHeight) {
      currentPeaks[i]=spaHeight;
    }    
    p.drawPixmap(i,0,(*peakMap),currentPeaks[i],0,1,spaHeight);
  } 

  p.end();                                // painting done
  bitBlt( this, 0,0, pixMap,0,0 );        
  spectrumAnalyserDevice->setEnabled(true);
}


  

void GuiSpectrumAnalyser::doUpdate() {
  repaint(false);
}




