/*
  gui part for the info device (very simple)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <guiInfoDevice.h>




GuiInfoDevice::GuiInfoDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {

  infoString=new Buffer(10);
  currentSong=new Song("");
  
  setMinimumSize( sizeHint() );

  infoDeviceConfig=new InfoDeviceConfig("InfoDeviceConfig",
					getPreferences());
  getPreferences()->addTab(infoDeviceConfig,infoDeviceConfig->getGroupName());
  insertMenu(i18n("Configure"),this,SLOT(configure()));
  connect(infoDeviceConfig,SIGNAL(applyEvent()), this, SLOT(apply()));
}


GuiInfoDevice::~GuiInfoDevice() {
  delete infoString;
  delete currentSong;
}


void GuiInfoDevice::configure() {
  getPreferences()->show();
  apply();
}


void GuiInfoDevice::apply() {
  update();
}


void GuiInfoDevice::mousePressEvent ( QMouseEvent* mouseEvent) {
  if (mouseEvent->button() ==  RightButton) {
    KPopupMenu* popupMenu=createPopupMenu();
    popupMenu->move(mapToGlobal(QPoint(mouseEvent->x(),mouseEvent->y())));
    popupMenu->exec();
    delete popupMenu;
  }
}



char* GuiInfoDevice::getInfoString() {
  infoDeviceConfig->translate(currentSong,infoString);
  return infoString->getData();
}


char* GuiInfoDevice::getName() {
  MusicInfo* musicInfo=currentSong->getMusicInfo();
  return musicInfo->getName();
}


int GuiInfoDevice::getLen() {
  MusicInfo* musicInfo=currentSong->getMusicInfo();
  return musicInfo->getLen();
}


QSize GuiInfoDevice::sizeHint() const {
  return QSize(140,40);
}


void GuiInfoDevice::paintEvent ( QPaintEvent * paintEvent ) {
  QPainter paint;

  erase(0,0,width(),height());
  paint.begin( this );
  paint.drawText(0,10,getInfoString());
  paint.end();  

}


void GuiInfoDevice::setSong(Song* aSong) {
  aSong->copyTo(currentSong);
  emit(setSongEvent());
}


Song* GuiInfoDevice::getSong() {
  return currentSong;
}





