/*
  start of a generic gui Device
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __GUIDEVICE_H
#define __GUIDEVICE_H

#include <kapp.h>
#include <menuDescription.h>
#include <kpopmenu.h>
#include <preferences.h>
#include <devices/outputDevice.h>



/**
  This add decoration stuff to the core gui device.<p>
  - popupmenus<p>
  - configuration options<p>
  - icons etc.....<p>


*/



class GuiDevice : public QWidget  {
  Q_OBJECT

  Preferences* preferences;
  OutputDevice* outputDevice;
  
 public:
  GuiDevice( QWidget *parent=0, const char *name=0 );
  ~GuiDevice();

  void insertMenu(const char* text,QObject* receiver,const char* signal);
  Preferences* getPreferences();
  KPopupMenu* createPopupMenu();
  virtual void attachTo(OutputDevice* device);  
  virtual void detach();

 protected slots:
  virtual void processEvent(char eventId);
 
 private:
  MenuDescription* menuDescription;

};


#endif



    
