/*
  gui part shows the audioBuffer fillgrade
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __GUIBUFFERINFODEVICE_H
#define __GUIBUFFERINFODEVICE_H

#include <qpainter.h>
#include <qpushbt.h>
#include <qlayout.h>


#include <devices/audioStreamInfoDevice.h>
#include <yafcore/buffer.h>

#include <guiDevice.h>




class GuiBufferInfoDevice : public GuiDevice {
  Q_OBJECT

  AudioStreamInfoDevice* audioStreamInfoDevice;
  int currentFillgrade;

 public:
  GuiBufferInfoDevice(QWidget *parent=0, const char *name=0);
  ~GuiBufferInfoDevice();
  void attachTo(AudioStreamInfoDevice* audioStreamInfoDevice);
  void detach();

  // number in the range from 0..100
  int getFillgrade();

  QSize sizeHint() const;
  void paintEvent (QPaintEvent* paintEvent);

 protected:
  void processEvent(char eventId);

};


#endif
