/*
  gui part for the balance device (very simple)
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __GUIBALANCEDEVICE_H
#define __GUIBALANCEDEVICE_H

#include <qpainter.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <kslider.h>
#include <menuDescription.h>
#include <kpopmenu.h>
#include <devices/volumeDevice.h>
#include <guiDevice.h>

#include <iostream.h>

/**
   This class uses a shared device. This means it gets the device
   from somewhere else and that it does not own the device.
   (do not deletee when this object is destroyed.)
   <p>
   For what is this good for.
   The Balance is set in a volumeDevice. It is clear that
   you only want one volume/Balance for one stream.
   Because of performance reasons the volumeDevice is shared
   with this Gui for a BalanceDevice. 
*/
   



class GuiBalanceDevice : public GuiDevice {
  Q_OBJECT

  int balance;  
  MenuDescription* menuDescription;
  VolumeDevice* volumeDevice;

 public:
  GuiBalanceDevice(QWidget *parent=0,const char *name=0 );
  ~GuiBalanceDevice();
  void attachTo(VolumeDevice* volumeDevice);
  void detach();

  void buildGui();
  void mousePressEvent ( QMouseEvent* mouseEvent);
  QSize sizeHint() const;
  bool eventFilter( QObject *, QEvent *e );
 public slots:
  // -100 : full left zero right
  //  100 : zero left full right
  
  void centerBalance();  
  void setBalance(int range);
  int getBalance();

 signals:
  void valueChanged(int percent);

 protected:
  QSlider* sb;

};


#endif
