/*
  a basic video player
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef _VIDEOPLAYER_H
#define _VIDEOPLAYER_H


#include <qlayout.h>
#include <qslider.h>
#include <qlabel.h>

#include <amplifier/amplifier.h>


#include <guiVideoDevice.h>



#include <drag.h>
#include <kurl.h>

class VideoPlayer : public QWidget {
  Q_OBJECT


  VideoDevice* videoDevice;
  GenericPlayer* genericPlayer;

  QSlider *sb;
  GuiVideoDevice* guiVideoDevice;
  KURL* currentUrl;
  QVBoxLayout* topLayout;


 public:
  VideoPlayer( QWidget *parent=0, const char *name=0 );
  ~VideoPlayer();

 public slots:
  int open(KURL* url);
  void jump(int percent);

  void addListener(NodeDevice* listener);

  // Called when files are droppen on the main window
  void onDrop( KDNDDropZone* );


 protected:
  void buildGUI();

  KDNDDropZone* dropZone;
};

#endif


  
