/*
  gui part for the video device (very simple)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <guiVideoDevice.h>




GuiVideoDevice::GuiVideoDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {
  setMinimumSize( sizeHint() );
  videoDevice=NULL;
}


GuiVideoDevice::~GuiVideoDevice() {

}


void GuiVideoDevice::attachTo(VideoDevice* videoDevice) {
  if (this->videoDevice != NULL) {
    cout << "videoDevice != NULL. call ignored"<<endl;
    return;
  }
  this->videoDevice=videoDevice;
  connect(videoDevice->getEventQueue(),SIGNAL(processEvent(char)),
	  this,SLOT(processEvent(char)));
  GuiDevice::attachTo(videoDevice);
}


void GuiVideoDevice::detach() {
  videoDevice=NULL;
  disconnect(this);
}



void GuiVideoDevice::processEvent(char eventId) {

  repaint(false);

 
}



QSize GuiVideoDevice::sizeHint () {
  return QSize(100,100);
}


void GuiVideoDevice::paintEvent ( QPaintEvent * paintEvent ) {

  QPainter paint;
  QPixmap* pixmap;

  if (videoDevice == NULL) {
    cout << "videoDevice == NULL"<<endl;
    return;
  }


  videoDevice->requestLock();


  pixmap=videoDevice->getCurrentPixmap();
  if (pixmap == NULL) {
    cout << "image null"<<endl;
    videoDevice->releaseLock();
    return;
  }

 
  paint.begin( this );
  paint.drawPixmap(0,0,*pixmap);
  paint.end();  
  videoDevice->releaseLock();



}
