/*
  selects the right/left channel in a stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "channelDevice.h"


ChannelDevice::ChannelDevice():OutputDevice("ChannelDevice") {
  channel=_CHANNEL_ALL;
}


ChannelDevice::~ChannelDevice() {
  cout << "destruktor channelDevice"<<endl;
}


char* ChannelDevice::getNodeName() {
  return "ChannelDevice";
}


/**
  This method is called by the GUI frontend.
  It sets the channel we dont want to hear
*/
void ChannelDevice::setChannel(int channel) {
  this->channel=channel;
}



/** 
   The method writeIn(...)is entered by a seperate thread.
   <p>
   Here you can directly modify the PCM stream!     
   <pre> 
   NodeDevice* source       the parent Device which calls this method
   DeviceConfig* buf        class which stores the various
                            information asociated with a PCM stream 
                            (eg: stereo,samplesize,name of song, etc...)
   </pre>
*/
void ChannelDevice::writeIn(NodeDevice* source,DeviceConfig* config) {
  AudioInfo* audioInfo;
  AudioBuffer* audioBuffer;
  MemChunk* pcmChunk;
  AudioStream* audioStream=config->getAudioStream();

  

  audioInfo=audioStream->getAudioInfo();
  if (audioInfo->getStereo() == false) {
    cout << "device does not work with mono data!"<<endl;
    return;
  }
  if (audioInfo->getSampleSize() != 16) {
    cout << "device does not work with samples != 16 Bit"<<endl;
    return;
  }

  if (channel == _CHANNEL_ALL) {
    return;                        // nothing to do!
  }

  audioBuffer=audioStream->getAudioBuffer();
  pcmChunk=audioBuffer->getMemChunk();

  // pcmChunk: This is the raw pcm data.
  // The idea is simple: we modify the selected channel by writing zero's
  // into it.

  int i;
  int len=pcmChunk->getLen()/2;       // div 2 because short = 16 Bit!
  // and len is the length in char
  short* pcmData=(short*)pcmChunk->getPtr();  // start pointer of data

  i=0;
  while(i<len) {
    if (channel == _CHANNEL_NONE) {
      pcmData[i]=0;
      pcmData[i+1]=0;
      i=i+2;
      continue;
    }
    if (channel == _CHANNEL_LEFT) {
      pcmData[i]=0;
      i=i+2;
      continue;
    }
    if (channel ==_CHANNEL_RIGHT) {
      pcmData[i+1]=0;
      i=i+2;
      continue;
    }
    cout << "unkown channel parameter!"<<endl;
  }
           
  // We modified the pcm stream.
  // We dont take care what happens after this. The thread leaves
  // this method an enteres the next device automatically

}


