/*
  Configuration for the tplay decoder
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <tplayDecoderConfig.h>


TplayDecoderConfig::TplayDecoderConfig(const char* configGroup,
				   QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();
}


TplayDecoderConfig::~TplayDecoderConfig() {
}


const char* TplayDecoderConfig::getGroupName() {
  return "tplay";
}


void TplayDecoderConfig::load() {
  config->setGroup(configGroup);
}


void TplayDecoderConfig::save() {
  config->setGroup(configGroup);
}


void TplayDecoderConfig::apply() {
  save();
  emit(applyEvent());
}

int TplayDecoderConfig::canHandle(Song* song) {
  if (song->getDecoderType()==_EXTENSION_WAV) {
    return true;
  }
  return false;

}
