/*
  Configuration for the splay decoder
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __SPLAYDECODERCONFIG_H
#define __SPLAYDECODERCONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <tag.h>
#include <song.h>
#include <amplifier/amplifier.h>


class SplayDecoderConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  DecoderID* decoderID;
  const char* configGroup;

  bool downsample_cfg;
  bool mono_cfg;

 public:
   SplayDecoderConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~SplayDecoderConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
 signals:
   void applyEvent();
   void restart();

 public slots:
   int canHandle(Song* song);
   DecoderID* getDecoderID();

 private:
   QCheckBox* downsampleBox;
   QCheckBox* monoBox;
   QGroupBox* infoBox;
   
};
#endif
