/*
  Configuration for the mpg decoder
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __MPGDECODERCONFIG_H
#define __MPGDECODERCONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <tag.h>
#include <song.h>
#include <amplifier/amplifier.h>
#include <qvalidator.h> 

class MPGDecoderConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;
  DecoderID* decoderID;

  bool downsample_cfg;
  bool mono_cfg;
  bool sync_cfg;
  bool calcLength_cfg;

 public:
   MPGDecoderConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~MPGDecoderConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
 signals:
   void applyEvent();
   void restart();

 public slots:
   int canHandle(Song* song);
   DecoderID* getDecoderID();

 private:
   QCheckBox* downsampleBox;
   QCheckBox* monoBox;
   QCheckBox* calcLengthBox;
   QCheckBox* syncBox;
   QGroupBox* infoBox;
   QLineEdit* lineEdit;
};
#endif
