/*
  Configuration for the crashHandling
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <crashConfig.h>


CrashConfig::CrashConfig(const char* configGroup,
				   QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();

  QVBoxLayout *vbox3 = new QVBoxLayout(this, 5);

  infoBox= new QGroupBox(i18n("Decoder Crash recovery"),this, "infoBox" );
  QVBoxLayout *vbox2 = new QVBoxLayout(infoBox, 5);
  vbox2->addSpacing( fontMetrics().height() );
 
  QWidget* w=new QWidget(infoBox);
  QVBoxLayout *vbox1 = new QVBoxLayout(w, 5);

 
  doWarnBox = new QCheckBox(i18n("warn if decoder crashes"),
			    w,"doWarn3Box");
  doWarnBox->setFixedSize(doWarnBox->sizeHint());
  doWarnBox->setChecked(doWarn_cfg);

  doInformBox = new QCheckBox(i18n("inform after restart"),
			    w,"doInformBox");
  doInformBox->setFixedSize(doInformBox->sizeHint());
  doInformBox->setChecked(doInform_cfg);

  playNextBox = new QCheckBox(i18n("play next after recovery"),w,
			      "playNextBox");
  playNextBox->setFixedSize(playNextBox->sizeHint());
  playNextBox->setChecked(playNext_cfg);
  
  vbox1->addWidget(doWarnBox,0,AlignLeft);
  vbox1->addWidget(doInformBox,0,AlignLeft);
  vbox1->addWidget(playNextBox,0,AlignLeft);

  vbox2->addWidget(w,0,AlignLeft);

  vbox3->addWidget(infoBox,0,AlignLeft);

  QLabel* lineLable1 = new QLabel(this);
  lineLable1->setText(
             i18n("Crashrecovery means, that even if the decoder"));

  QLabel* lineLable2 = new QLabel(this);
  lineLable2->setText(
             i18n("crashes with a segfault, the gui knows how to"));

  QLabel* lineLable3 = new QLabel(this);
  lineLable3->setText(
             i18n("handle this."));

  lineLable1->setFixedSize(lineLable1->sizeHint());
  lineLable2->setFixedSize(lineLable2->sizeHint());
  lineLable3->setFixedSize(lineLable3->sizeHint());

  vbox3->addWidget(lineLable1,0,AlignLeft);
  vbox3->addWidget(lineLable2,0,AlignLeft);
  vbox3->addWidget(lineLable3,0,AlignLeft);
  vbox3->addSpacing( 50 );

  
  

  QLabel* lineLable4 = new QLabel(this);
  lineLable4->setText(i18n("Terminate the decoder if it hangs"));

  QLabel* lineLable5 = new QLabel(this);
  lineLable5->setText(i18n("on a slow http request."));

  lineLable4->setFixedSize(lineLable4->sizeHint());
  lineLable5->setFixedSize(lineLable5->sizeHint());
  vbox3->addWidget(lineLable4,0,AlignLeft);
  vbox3->addWidget(lineLable5,0,AlignLeft);
  vbox3->addSpacing( 25 );

  QPushButton* button=new QPushButton(i18n("terminate decoder"),this);
  button->setFixedSize(button->sizeHint());
  vbox3->addWidget(button,0,AlignLeft);
  
  connect(button,SIGNAL(clicked()),SIGNAL(killDecoder()));

}


CrashConfig::~CrashConfig() {
}


const char* CrashConfig::getGroupName() {
  return i18n("Crash");
}


void CrashConfig::load() {
  config->setGroup(configGroup);
  doWarn_cfg=config->readBoolEntry( "doWarn", true);
  doInform_cfg=config->readBoolEntry( "doInform", true);
  playNext_cfg=config->readBoolEntry("playNext",true);
}


void CrashConfig::save() {
  doWarn_cfg=doWarnBox->isChecked();
  playNext_cfg=playNextBox->isChecked();
  doInform_cfg=doInformBox->isChecked();

  config->setGroup(configGroup);
  config->writeEntry("doWarn",doWarn_cfg);
  config->writeEntry("doInform",doInform_cfg);
  config->writeEntry("playNext",playNext_cfg);
}


void CrashConfig::apply() {
  save();
  emit(applyEvent());
}


int CrashConfig::getDoWarn() {
  return (int)doWarnBox->isChecked();
}

int CrashConfig::getDoInform() {
  return (int)doInformBox->isChecked();
}


int CrashConfig::getPlayNext() {
  return (int)playNextBox->isChecked();
}

