/*
  a view for a song.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __SONGVIEW1_H
#define __SONGVIEW1_H

#include <song.h>
#include <qlistbox.h>
#include <infoDeviceConfig.h>

class SongView1 : public QListBoxItem {

   public:
      SongView1(Song* song,InfoDeviceConfig* infoDeviceConfig);
      ~SongView1();
      void doUpdate();

   protected:
      void paint( QPainter* );
      int height( const QListBox* ) const;
      int width( const QListBox* ) const;
   private:
      Song* song;
      InfoDeviceConfig* infoDeviceConfig;
      Buffer* songName;
};



#endif
