/*
  dialog for skin selection
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __SKINCONFIG_H
#define __SKINCONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <guiPlugin.h>


#define __SKINID_EXAMPLE      3

class SkinConfig  : public PrefConfig {
 Q_OBJECT
   
   KConfig* config;
   const char* configGroup;
   char* dirname_cfg;
   int skinId_cfg;

 public:
  SkinConfig(const char* configGroup,
	     QWidget * parent=0, const char * name=0 );
  ~SkinConfig();

  const char* getGroupName();
  void load();
  void save();
  void apply();
  GuiPlugin* createGuiPlugin(QWidget* parent);


 signals:
   void applyEvent();
   void configSkinEvent();

 public slots:
  void setDirName(char*);
  char* getDirName();

  void setSkinId(int skinId);
  int getSkinId();

  void configSkin();

 
};


#endif
