/*
  dialog for selecting from which decoder we take input
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __SELECTINPUTDIALOG_H
#define __SELECTINPUTDIALOG_H



#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <tag.h>
#include <song.h>
#include <amplifier/amplifier.h>
#include <players/inputPlugin/inputDetector.h>
#include "oacBox.h"
#include <qfileinfo.h> 
#include <kmsgbox.h>



class SelectInputDialog : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;
  DecoderID* decoderID;

 public:
   SelectInputDialog(QWidget * parent=0, const char * name=0 );
   ~SelectInputDialog();

 public slots:
 
   DecoderID* getDecoder(Song* target);

   int getDefaultDecoder();
   void setDefaultDecoder(int decoder);

   int getAlwaysChecked();
   void setAlwaysCheck(int lAlways);
   
   void disableAutodetect();
   void enableAutodetect();
   


   const char* getGroupName();

   void load();
   void save();
   void apply();
   void makeVisible();


 signals:
   void applyEvent();
   void changeDefaultDecoder();
   

 private:   
   DecoderID* extension2Decoder(int extension);
   DecoderID* url2Decoder(const char* url);

   int lWantAlways_cfg;
   int nDefaultDecoder_cfg;
   QButtonGroup* bg;
   QCheckBox* alwaysUseBox;
   QRadioButton* autoDetectButton;
};
#endif

