/*
  dialog for selecting from which decoder we take input
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "selectInputDialog.h"


SelectInputDialog::SelectInputDialog(QWidget* parent=0, const char * name=0 ): PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  decoderID=new DecoderID(_NO_DECODER,0,NULL);
  load();

  QVBoxLayout *vbox3 = new QVBoxLayout(this, 5);
  vbox3->addSpacing( fontMetrics().height() );

  QLabel* infoLabel1 = new QLabel(this);
  infoLabel1->setText(i18n("Select the input player for kmpg."));
  infoLabel1->setFixedSize(infoLabel1->sizeHint());

  vbox3->addWidget(infoLabel1,0,AlignLeft);

  bg = new QButtonGroup(i18n("Use"), this );
  QVBoxLayout *vbox2 = new QVBoxLayout(bg, 5);
  vbox2->addSpacing( bg->fontMetrics().height() );


  QWidget* w=new QWidget(bg);
  QVBoxLayout *vbox1 = new QVBoxLayout(w, 5);



  QRadioButton* rb1 = new QRadioButton(i18n("mp3 decoder"),w);
  bg->insert(rb1,_EXTENSION_MP3);
  rb1->setFixedSize( rb1->sizeHint() );

  QRadioButton* rb2 = new QRadioButton(i18n("wav decoder"),w);
  rb2->setFixedSize( rb2->sizeHint() );
  bg->insert(rb2,_EXTENSION_WAV);
 

  QRadioButton* rb3 = new QRadioButton(i18n("mpeg video decoder"),w);
  rb3->setFixedSize( rb3->sizeHint() );
  bg->insert(rb3,_EXTENSION_MPEG);
  
  autoDetectButton = new QRadioButton(i18n("autodetection"),w);
  autoDetectButton->setMinimumSize( autoDetectButton->sizeHint() );
  bg->insert(autoDetectButton,_EXTENSION_AUTO);
 
  vbox1->addWidget(rb1,0,AlignLeft);
  vbox1->addWidget(rb2,0,AlignLeft);
  vbox1->addWidget(rb3,0,AlignLeft);
  vbox1->addWidget(autoDetectButton,0,AlignLeft);

  vbox2->addWidget(w,0,AlignLeft);
  vbox3->addWidget(bg,0,AlignLeft);


  bg->setButton(nDefaultDecoder_cfg);
  setDefaultDecoder(nDefaultDecoder_cfg);


  alwaysUseBox = new QCheckBox(i18n("always"),this,"alwaysUseBox");
  alwaysUseBox->setFixedSize(alwaysUseBox->sizeHint());
  vbox3->addWidget(alwaysUseBox,0,AlignLeft);
 
  
  connect(bg,SIGNAL(pressed (int)),SLOT(setDefaultDecoder(int)));

  OACBox* oacBox=new OACBox(this);

  connect(oacBox , SIGNAL(ok()), SLOT(save()) );
  connect(oacBox , SIGNAL(apply()), SLOT(apply()) );
  connect(oacBox , SIGNAL(cancel()),this, SLOT(hide()) );

  vbox3->addWidget(oacBox,0,AlignLeft);

  setFixedSize(QSize(400,150));

  
}


SelectInputDialog::~SelectInputDialog() {
}


const char* SelectInputDialog::getGroupName() {
  return "SelectInputDialog";
}


void SelectInputDialog::load() {
  // we know what the user want.
  nDefaultDecoder_cfg=_EXTENSION_AUTO;
  lWantAlways_cfg=false;
}


void SelectInputDialog::save() {
  apply();
  close();
}


void SelectInputDialog::apply() {
  lWantAlways_cfg=alwaysUseBox->isChecked();
  emit(applyEvent());
}



int SelectInputDialog::getDefaultDecoder() {
  return nDefaultDecoder_cfg;
}
 
void SelectInputDialog::setDefaultDecoder(int decoder) {
  nDefaultDecoder_cfg=decoder;
}

int SelectInputDialog::getAlwaysChecked() {
  return lWantAlways_cfg;
}


void SelectInputDialog::setAlwaysCheck(int lAlways) {
  lWantAlways_cfg=lAlways;
}
   

  


DecoderID* SelectInputDialog::getDecoder(Song* target) {
  if (nDefaultDecoder_cfg != _EXTENSION_AUTO) {
    if (lWantAlways_cfg) {
      return extension2Decoder(nDefaultDecoder_cfg);
    }

  }
  // otherwise check for decoder
  const char* file=target->getSongLocation();
  int extension=nDefaultDecoder_cfg;
  DecoderID* back=extension2Decoder(extension);

  if (nDefaultDecoder_cfg == _EXTENSION_AUTO) {
    extension=Extension::getDecoderType(file);
    back=extension2Decoder(extension);
  }
  if (nDefaultDecoder_cfg == _EXTENSION_AUTO) {
    if (back->getID() == _NO_DECODER) {
      back=url2Decoder(file);
    }
  }

  
  nDefaultDecoder_cfg=_EXTENSION_AUTO;
  bg->setButton(_EXTENSION_AUTO);
  return back;

}


void SelectInputDialog::disableAutodetect() {
  autoDetectButton->setEnabled(false);
}


void SelectInputDialog::enableAutodetect() {
  autoDetectButton->setEnabled(true);
}
   

DecoderID* SelectInputDialog::extension2Decoder(int extension) {
  delete decoderID;
  switch(extension) {
  case _EXTENSION_WAV: {
    decoderID=Amplifier::createStandardDecoderID(_WAV_DECODER);
    break;
  }
  case _EXTENSION_MP3: {
    decoderID=Amplifier::createStandardDecoderID(_MP3_DECODER);
    break;
  }
  case _EXTENSION_MPEG: {
    decoderID=Amplifier::createStandardDecoderID(_MPEG_VIDEO_DECODER);
    break;    
  }
  default :
    // now try well know url and map them
    decoderID=Amplifier::createStandardDecoderID(_NO_DECODER);
    break;  
  }
  return decoderID;
}


DecoderID* SelectInputDialog::url2Decoder(const char* url) {
  delete decoderID;
  int inputType=InputDetector::getInputType(url);
  switch(inputType) { 
  case __INPUT_CDI: {
    decoderID=Amplifier::createStandardDecoderID(_MPEG_VIDEO_DECODER);
    KURL aurl(url);
    QFileInfo fileInfo(aurl.path());
    QString msg2;
    msg2 = i18n("kmpg has no access!");
    msg2 += "\n\n";
    msg2 += aurl.path();
    msg2 += "\n";
    msg2 += i18n("needed permissions:");
    msg2 += "\n";
    int laccessok=true;
    if (fileInfo.isReadable()==false) {
      laccessok=false;
      msg2 += i18n("read access");
      msg2 += "\n";
   }
    if (fileInfo.isWritable()==false) {
      laccessok=false;
      msg2 += i18n("write access");
      msg2 += "\n";
    }   
    if (laccessok == false) {
      msg2 += "\n\n";
      KMsgBox::message(NULL,i18n("Permission error"),msg2.data());
    }
    break;
  }
  default :
    // now try well know url and map them
    decoderID=Amplifier::createStandardDecoderID(_NO_DECODER);
    break;  
  }
  return decoderID;
}
 


void SelectInputDialog::makeVisible() {
  if (isVisible()) {
    hide();
  }
  show();
}
