/*
  Configuration Dialog for playlistView1
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <playlistView1Config.h>


#include <playlist_xpm.h>


PlaylistView1Config::PlaylistView1Config(QWidget * parent=0, const char * name=0 )
                     : PrefConfig(parent,name) {
  config = kapp->getConfig();
  configGroup="PlaylistView1";
  load();

 
  QButtonGroup *bg = new QButtonGroup(i18n("playlist drop action"), this );
  QVBoxLayout *vbox = new QVBoxLayout(bg, 5);
  vbox->addSpacing( bg->fontMetrics().height() );
  QRadioButton* rb1 = new QRadioButton(i18n("smart drop"),bg );
  bg->insert(rb1,_PLV1_SMART_DROP);
  rb1->setMinimumSize( rb1->sizeHint() );

  QRadioButton* rb2 = new QRadioButton(i18n("always at end") ,bg );
  rb2->setMinimumSize( rb2->sizeHint() );
  bg->insert(rb2,_PLV1_AT_END);
 

  vbox->addWidget(rb1);
  vbox->addWidget(rb2);
  bg->setButton(dropMode_cfg);
  setDropMode(dropMode_cfg);
  bg->setGeometry(20, 40, 300, 120 );

  QLabel* lineLable = new QLabel(this);
  lineLable->setGeometry(20,180,300,20);
  lineLable->setText(i18n("Note: if dropped here it is always appended"));

  QLabel* pixmapLable = new QLabel(this);
  pixmapLable->setGeometry(20,200,238,163);
  pixmapLable->setPixmap(playlist_xpm);
 
  connect(bg,SIGNAL(pressed (int)),SLOT(setDropMode(int)));
}


PlaylistView1Config::~PlaylistView1Config() {
}


char* PlaylistView1Config::getGroupName() {
  return "DropMode";
}


void PlaylistView1Config::load() {
  config->setGroup(configGroup);
  dropMode_cfg=config->readNumEntry("dropMode",_PLV1_AT_END);
}


void PlaylistView1Config::save() {
  config->setGroup(configGroup);
  config->writeEntry("dropMode",dropMode_cfg);
}


void PlaylistView1Config::apply() {
  save();
}


void PlaylistView1Config::setDropMode(int mode) {
  this->dropMode_cfg=mode;
}


int PlaylistView1Config::getDropMode() {
  return dropMode_cfg;
}





  
