/*
  fileoperations with the playlist model
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */






#ifndef __PLAYLISTOPERATION_H
#define __PLAYLISTOPERATION_H

#include <playlist.h>
#include <drag.h>

#include <qtstream.h> 
#include <qfileinfo.h> 
#include <iostream.h>
#include <kapp.h>


class PlaylistOperation {

 public:
  PlaylistOperation();
  ~PlaylistOperation();

  static int writePlaylist(Playlist* playlist);
  static void printPlaylist(Playlist* playlist);
  
  static Playlist* readPlaylist();
  static int loadSong(Playlist* playlist);
  static void rootInsert(KDNDDropZone* src,Playlist* dest,int pos=-1);
  static void rootInsert(QStrList* src,Playlist* dest,int pos=-1);
  static void rootInsert(char* filename,Playlist* dest,int pos=-1);

  static int insert(Playlist* src,Playlist* dest,int pos=-1);
  static int insert(QStrList* src,Playlist* dest,int pos=-1);
  static void playNext(Playlist* playlist);
  static void playPrev(Playlist* playlist);
  static void playCurrent(Playlist* playlist);
  static int  getRandom(Playlist* playlist);
  static void playShuffle(Playlist* playlist);
  static int  canProcess(char* file,Playlist* playlist,Buffer* destfile);
  static void readPlaylist(char* filename,Playlist* playlist,int pos=-1);
  static void playNextNotCorrupt(Playlist* playlist);
  static void playPrevNotCorrupt(Playlist* playlist);
  static char* getLastPath();
  static void setLastPath(const char* path);
  
   
};
#endif
