/*
  The playlist class. An element in a modell.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __PLAYLIST_H
#define __PLAYLIST_H

#include <song.h>
#include <qlist.h>

class Playlist : public QObject {
 Q_OBJECT

  QList<Song> songList;
  int playSongPos;
  int lShuffle;
  int lRepeat;
  Buffer* name;

 public:
  Playlist();
  ~Playlist();

  int count();
  int getCurrentPos();
  int getPlaySongPos();
  Song* at(int index);
  int getShuffle();
  int getRepeat();
  int find(Song* song);
  char* getName();
  

 public slots:
  void addSong(Song* song,int index=-1);
  void removeSong(int index);
  void swapSong(int index1,int index2);
  void setCurrentPos(int index);
  void playSong(int index);
  void clear();
  void setShuffle(int lShuffle);
  void setRepeat(int lRepeat);
  void songUpdate(Song* song);
  void setName(char* name);

 signals:
  void songUpdateEvent(Song* song,int index);
  void addSongEvent(Song* song,int index);
  void removeSongEvent(int index);
  void swapSongEvent(int index1,int index2);
  void setNameEvent();
  void setCurrentPosEvent(int index);
  void playSongEvent(int index);
  void clearEvent();
  void setShuffleEvent(int);
  void setRepeatEvent(int);
  void setNameEvent(char*);
  
};
#endif
