/*
  The playlist class. An element in a modell.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <playlist.h>


Playlist::Playlist() {
  playSongPos=-1;
  lShuffle=false;
  lRepeat=false;
  name=new Buffer(40);
}


Playlist::~Playlist() {
  delete name;
}

int Playlist::getPlaySongPos() {
  return playSongPos;
}


/**
   The add event must not have a side effect on the currentPos.
*/
void Playlist::addSong(Song* song,int index=-1) {
  if (index < 0) {
    index =songList.count();
  }
  if ((uint)index > songList.count()) {
    index=songList.count();
  }
  int current=songList.at();
  songList.insert(index,song);
  connect(song,SIGNAL(songUpdateEvent(Song*)),this,SLOT(songUpdate(Song*)));

  if ((playSongPos > 0) && (index >= 0)) {
    if (index < playSongPos) {
      playSongPos++;
    }
  }

  /**
     This fixes the problem that after an insert the item
     becomes the current one.
     An add operations must not have a side effect
  */
  if (current == -1) {
    current=0;
  }
  if (current > index) {
      current++;
  }
  emit(addSongEvent(song,index));
  setCurrentPos(current);
}

/**
   The remove operation should have as less side effects
   as possible.
*/
void Playlist::removeSong(int index) {
  int current=songList.at();
  Song* song=at(index);
  
  if (song != NULL) {
    disconnect(song,0,this,0);
  }

  if (songList.remove(index)) {
    if (count() > 0) {
      if (current > index) {
	current--;
      }
    }
    if ((playSongPos > 0) && (index >= 0)) {
      if (playSongPos == index) {
	playSongPos=-1;
	cout << "PlaySong removed:"<<playSongPos<<endl;
      } else {
	if (index < playSongPos) {
	  playSongPos--;
	  cout << "PlaySongPos:"<<playSongPos<<endl;
	}
      }
    }
    
  
    emit(removeSongEvent(index));
    setCurrentPos(current);
  }
}


void Playlist::swapSong(int index1,int index2) {
  Song* s1;
  Song* s2;
  
  if (index2 < index1) {
    int tmp= index1;
    index1=index2;
    index2=tmp;
  }
  s1=songList.at(index1);
  s2=songList.at(index2);  
  songList.take(index2);
  songList.take(index1);
  songList.insert(index1,s2);
  songList.insert(index2,s1);

  if ((index1 == playSongPos)) {
    playSongPos=index2;
  } else {
    if ((index2 == playSongPos)) {
      playSongPos=index1;
    }
  }

  emit( swapSongEvent(index1,index2) );
}


int Playlist::count() {
  return songList.count();
}


Song* Playlist::at(int index) {
  Song* back;
  int pos=getCurrentPos();
  back=songList.at(index);
  songList.at(pos);
  return back;
}


void Playlist::clear() {
  songList.clear();
  emit( clearEvent() );
}


void Playlist::setCurrentPos(int index) {
  if ((index >= count()) || (index < 0)) {
    return;
  }
  if ((index == 0) && (count() == 0)) {
    return;
  }
  if (songList.at(index) != NULL) {
    emit(setCurrentPosEvent(index));
  }
}


int Playlist::getCurrentPos() {
  return songList.at();
}


void Playlist::playSong(int index) {
  if (songList.at(index) != NULL) {
    playSongPos=index;
    
    emit(playSongEvent(index));
  }
}


int Playlist::getShuffle() {
  return lShuffle;
}


void Playlist::setShuffle(int lShuffle) {
  if (this->lShuffle != lShuffle) {
    this->lShuffle=lShuffle;
    int i;
    Song* song;

    for(i=0;i<count();i++) {
      song=at(i);
      song->setShufflePlay(false);
    }
    emit(setShuffleEvent(lShuffle));
  }
}


int Playlist::getRepeat() {
  return lRepeat;
}


void Playlist::setRepeat(int lRepeat) {
  if (this->lRepeat != lRepeat) {
    this->lRepeat=lRepeat;
    emit(setRepeatEvent(lRepeat));
  }
}


int Playlist::find(Song* song) {
  int currentPos=getCurrentPos();
  int back=songList.find(song);
  songList.at(currentPos);
  return back;
}



void Playlist::songUpdate(Song* song) {
  int index=find(song);
  if (index >=0) {
    emit(songUpdateEvent(song,index));
  }
}

char* Playlist::getName() {
  return name->getData();
}


void Playlist::setName(char* newName) {
  name->clear();
  name->append(newName);
  emit(setNameEvent(getName()));
}
