/*
  Configuration for the nasDevice
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __NASDEVICECONFIG_H
#define __NASDEVICECONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <tag.h>
#include <song.h>
#include <qtimer.h>


class NASDeviceConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;

  bool lEnable_cfg;
  bool lStopIsEOF_cfg;
  

 public:
   NASDeviceConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~NASDeviceConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
 signals:
   void applyEvent();

 public slots:
   void setServerString(const char* serverString);
   void setVendorString(const char* vendorString);
   void setMajorVersion(int major);
   void setMinorVersion(int minor);

   char* getDisplay();

 private:
   QString majorString;
   QString minorString;
 
   QLabel* serverStringLabel;
   QLabel* vendorStringLabel;
   QLabel* majorVersionLabel;
   QLabel* minorVersionLabel;
   QComboBox* dirEdit;
   Buffer* display;

};
#endif
