/*
  Configuration for the nasDevice
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <nasDeviceConfig.h>


NASDeviceConfig::NASDeviceConfig(const char* configGroup,
				   QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {
 
  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();
  display=new Buffer(50);

  QVBoxLayout *vbox = new QVBoxLayout(this, 5);
  vbox->addSpacing( fontMetrics().height() );

  QLabel* lineLable1 = new QLabel(this);
  lineLable1->setText(i18n("Display:"));
  lineLable1->setFixedSize(lineLable1->sizeHint());


  dirEdit= new QComboBox (true, this );
  dirEdit->setFixedSize(QSize(300, 25));
  dirEdit->setSizeLimit(5);

  vbox->addWidget(lineLable1,0,AlignLeft);
  vbox->addWidget(dirEdit,0,AlignLeft);
  

  QGroupBox* infoBox=new QGroupBox(i18n("NAS Server info"),this, "infoBox" );

  QVBoxLayout *vbox1 = new QVBoxLayout(infoBox, 5);
  vbox1->addSpacing( infoBox->fontMetrics().height() );

  
  QWidget* w=new QWidget(infoBox);
  QVBoxLayout *vbox2 = new QVBoxLayout(w, 5);


  
  QLabel* lineLabel2=new QLabel(w);
  lineLabel2->setText(i18n("Server:"));
  lineLabel2->setFixedSize(lineLabel2->sizeHint());


  serverStringLabel=new QLabel(w);
  serverStringLabel->setGeometry(20,40,300,20);
  serverStringLabel->setText("");
  
  QLabel* lineLabel3=new QLabel(w);
  lineLabel3->setText(i18n("Vendor:"));
  lineLabel3->setFixedSize(lineLabel3->sizeHint());


  vendorStringLabel=new QLabel(w);
  vendorStringLabel->setGeometry(20,90,300,20);
  vendorStringLabel->setText("");


  QLabel* lineLabel4=new QLabel(w);
  lineLabel4->setText(i18n("MajorID:"));
  lineLabel4->setFixedSize(lineLabel4->sizeHint());


  majorVersionLabel=new QLabel(w);
  majorVersionLabel->setText("123");
  majorVersionLabel->setGeometry(20,140,300,20);

  QLabel* lineLabel5=new QLabel(w);
  lineLabel5->setText(i18n("MinorID:"));
  lineLabel5->setFixedSize(lineLabel5->sizeHint());


  minorVersionLabel=new QLabel(w);
  minorVersionLabel->setGeometry(20,190,300,20);
  minorVersionLabel->setText("456");




  vbox2->addWidget(lineLabel2,0,AlignLeft);
  vbox2->addWidget(serverStringLabel,0,AlignLeft);
  vbox2->addWidget(lineLabel3,0,AlignLeft);
  vbox2->addWidget(vendorStringLabel,0,AlignLeft);
  vbox2->addWidget(lineLabel4,0,AlignLeft);
  vbox2->addWidget(majorVersionLabel,0,AlignLeft);
  vbox2->addWidget(lineLabel5,0,AlignLeft);
  vbox2->addWidget(minorVersionLabel,0,AlignLeft);


  vbox1->addWidget(w,0,AlignLeft);
  

  vbox->addWidget(infoBox,0,AlignLeft);
  
    

}

NASDeviceConfig::~NASDeviceConfig() {
  delete display;
}


const char* NASDeviceConfig::getGroupName() {
  return "NAS";
}


void NASDeviceConfig::load() {
  config->setGroup(configGroup);
}


void NASDeviceConfig::save() {
  config->setGroup(configGroup);
}


void NASDeviceConfig::apply() {
  save();
  emit(applyEvent());
  dirEdit->insertItem(dirEdit->currentText());
}


void NASDeviceConfig::setServerString(const char* serverString) {
  serverStringLabel->setText(serverString);
}


void NASDeviceConfig::setVendorString(const char* vendorString) {
  vendorStringLabel->setText(vendorString);
}

 
void NASDeviceConfig::setMajorVersion(int major) {
  majorString.setNum(major);
  majorVersionLabel->setText(majorString);
}


void NASDeviceConfig::setMinorVersion(int minor) {
  minorString.setNum(minor);
  minorVersionLabel->setText(minorString); 
}

 
char* NASDeviceConfig::getDisplay() {
  QString string=dirEdit->currentText();
  display->clear();
  display->append(string.data());
  return (display->getData());
}


