/*
  a basic player
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef _PLAYER_H
#define _PLAYER_H


#include <playlistOperation.h>
#include <standardGraph.h>
#include <guiPlugin.h>
#include <selectInputDialog.h>

/**
   The task of the kmpgPlayer class is to connect the gui to
   the current playlist. The guiplugin nows nothing about
   the playlist but emits a few signals concerning the
   playlist, like playNext() for example.
   This class knows what to do with these signal.
   In the constrution process of a gui the kmpgMainWindow
   class sometime calls the setGuiPlugin(..) this is the
   time for the kmpgPlayer class to grap the signals from
   the plugin make some useful things with them.
   Then the player emits events about things he does not
   know about either. These are signals like open,play,pause.
   These signals must be forwarded to the current decoder.
*/


class KmpgPlayer : public QObject {
  Q_OBJECT

 public:
  KmpgPlayer(Playlist* playlist);
  ~KmpgPlayer();

   void setGuiPlugin(GuiPlugin* guiPlugin);
   GuiPlugin* getGuiPlugin();

 private slots:

   void playCurrentEvent();
   void playSongEvent(int index);
   void playNext();
   void playPrev();
   void configure();


 signals:
   void openEvent(Song*,DecoderID* decoderId);
   void playEvent();
   void jumpEvent(int second);
   void pauseEvent();
   void stopEvent();

 private: 
  
   // which decoder to use 
  SelectInputDialog* selectInputDialog;

  // and the current gui
  GuiPlugin* guiPlugin;

  //Yes, we know the playlist
  Playlist* playlist;
};

#endif


  
