/*
  a basic player
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <kmpgPlayer.h>



KmpgPlayer::KmpgPlayer(Playlist* playlist) {
  this->playlist=playlist;
  guiPlugin=NULL;
  selectInputDialog=new SelectInputDialog();
  connect(playlist,SIGNAL(playSongEvent(int)),this,SLOT(playSongEvent(int)));
  connect(selectInputDialog,SIGNAL(applyEvent()),
	  this,SLOT(playCurrentEvent()));
}


KmpgPlayer::~KmpgPlayer() {
  delete selectInputDialog;
} 


void KmpgPlayer::playCurrentEvent() {
  PlaylistOperation::playCurrent(playlist);
}

void KmpgPlayer::playSongEvent(int index) {
  Song* song=playlist->at(index);
  
  // do not play empty songs.
  if (strlen(song->getSongLocation())==0) {
    return;
  }

  DecoderID* id=selectInputDialog->getDecoder(song);
  int idNr=id->getID();
  if (idNr == _NO_DECODER) {
    QString msg2;
    const char* url=song->getSongLocation();
    msg2 += i18n("kmpg cannot determine the filetype for:");
    msg2 += "\n\n";
    msg2 += i18n("song:");
    msg2 += url;
    msg2 += "\n\n";
    msg2 += i18n("Please select the input manually");
    
    KMsgBox::message(NULL,i18n("no input found"),msg2.data());
    // obviously the user had "autodetect on when we are here.
    // Thus disable it 
    selectInputDialog->hide();
    selectInputDialog->show();
    return;
  }
  
  emit(openEvent(song,id));

  if (guiPlugin != NULL) {
    guiPlugin->setSong(song);
  } else {
    cout <<"guiPlugin==NULL"<<endl;
  }
}


void KmpgPlayer::playNext() {
  PlaylistOperation::playNext(playlist);
}


void KmpgPlayer::playPrev() {
  PlaylistOperation::playPrev(playlist);
}


void KmpgPlayer::setGuiPlugin(GuiPlugin* guiPlugin) {

  if (guiPlugin == NULL) {
    cout << "setting NULL guiPlugin!"<<endl;
    exit(0);
  }
  // Ok now we connect the signals from the gui to our slots.
  connect(guiPlugin,SIGNAL(playCurrentEvent()),this,SIGNAL(playEvent()));
  connect(guiPlugin,SIGNAL(playNextEvent()),this,SLOT(playNext()));
  connect(guiPlugin,SIGNAL(playPrevEvent()),this,SLOT(playPrev()));
  connect(guiPlugin,SIGNAL(playStopEvent()),this,SIGNAL(stopEvent()));
  connect(guiPlugin,SIGNAL(playPauseEvent()),this,SIGNAL(pauseEvent()));

  connect(guiPlugin,SIGNAL(jump(int)),this,SIGNAL(jumpEvent(int)));
  this->guiPlugin=guiPlugin;
  int current=playlist->getPlaySongPos();
  Song* song=playlist->at(current);
  if (song != NULL) {
    guiPlugin->setSong(song);
  }
  int lShuffle=playlist->getShuffle();
  int lRepeat=playlist->getRepeat();
  guiPlugin->setRepeat(lRepeat);
  guiPlugin->setShuffle(lShuffle);
  connect(guiPlugin,SIGNAL(repeatClickedEvent(int)),
	  playlist,SLOT(setRepeat(int)));

  connect(guiPlugin,SIGNAL(shuffleClickedEvent(int)),
	  playlist,SLOT(setShuffle(int)));

  
}



GuiPlugin* KmpgPlayer::getGuiPlugin() {
  return guiPlugin;
}





void KmpgPlayer::configure() {
  selectInputDialog->makeVisible();
}
