/*
  stores commandLine (nargs,args)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <ipc/commandLineCreator.h>



CommandLineCreator::CommandLineCreator() {
  nargs=0;
  args=NULL;
  current=0;
}


CommandLineCreator::~CommandLineCreator() {
  reset();
}


void CommandLineCreator::setNArgs(int n) {
  reset();
  this->nargs=n;
  args=new char*[nargs];
}


void CommandLineCreator::addArg(char* para) {
  int len=strlen(para);
  if (current == nargs) {
    cout << "ignored entry to commandline:"<<para<<endl;
    return;
  }
  args[current]=new char[len+1];
  strcpy(args[current], para);
  current++;
}



char** CommandLineCreator::getArgs() {
  return args;
}


int CommandLineCreator::getNArgs() {
  if (current < nargs) {
    return current;
  }
  return nargs;
}


void CommandLineCreator::reset() {
  int i;
  if (nargs > 0) {
    for(i=0;i<current;i++) {
      delete args[i];
    }
    current=0;
    delete args;
    nargs=0;
  }
}



void CommandLineCreator::print() {
  int i;
  cout << "nargs:"<<nargs<<endl;
  if (nargs > 0) {
    for(i=0;i<current;i++) {
      cout << "parameter: "<<i<<" value: "<<args[i]<<endl;
    }
  }
}


 
