/*
  Wrapper for Antoines tagEditor.
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __PLAYLISTVIEW3_H
#define __PLAYLISTVIEW3_H

#include <playlist.h>
#include <id/tagEditor.h>

/**
   Antoine Laydier (smf@mail.dotcom.fr) has written a very modular
   id3 tag editor. This class is a wrapper so that the tagEditor
   works with kmpgs playlist model.

*/

class PlaylistView3 : public QObject {
 Q_OBJECT

  TagEditor* tagEditor;
  Playlist* playlist;
  Song* currentSong;
  Tag* tag;
  Layer* layer;

 public:
  PlaylistView3(Playlist* playlist);
  ~PlaylistView3();

 public slots:
  void show();
  void setCurrentPosEvent(int index);
  void tagChanged();

};
#endif
