/*
  Configuration for the audioDevice
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <audioDeviceConfig.h>


AudioDeviceConfig::AudioDeviceConfig(const char* configGroup,
				   QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();

  QVBoxLayout *vbox2 = new QVBoxLayout(this, 5);
  vbox2->addSpacing( fontMetrics().height() );
  autoCloseBox = new QCheckBox(i18n("close after 2 seconds"),
			    this,"autoCloseBox");
  autoCloseBox->setFixedSize(autoCloseBox->sizeHint());
  autoCloseBox->setChecked(lAutoClose_cfg);
  vbox2->addWidget(autoCloseBox,0,AlignLeft);

  overrideBox = new QCheckBox(i18n("automatic initialisation"),
			    this,"overrideBox");
  overrideBox->setFixedSize(overrideBox->sizeHint());
  overrideBox->setChecked(lAutoInit_cfg);
  vbox2->addWidget(overrideBox,0,AlignLeft);

  sssBox=new SSSBox(this);
  vbox2->addSpacing(20);
  vbox2->addWidget(sssBox,0,AlignLeft);
  
  connect(overrideBox,SIGNAL(toggled(bool)),this,SLOT(autoInitToggle()));
  autoInitToggle();
}

AudioDeviceConfig::~AudioDeviceConfig() {
}


const char* AudioDeviceConfig::getGroupName() {
  return i18n("Native");
}


void AudioDeviceConfig::load() {
  config->setGroup(configGroup);
  lAutoClose_cfg=config->readBoolEntry( "autoClose", true);
  lAutoInit_cfg=true;
}


void AudioDeviceConfig::save() {
  lAutoClose_cfg=autoCloseBox->isChecked();

  config->setGroup(configGroup);
  config->writeEntry("autoClose",lAutoClose_cfg);
}


void AudioDeviceConfig::apply() {
  save();
  emit(applyEvent());
}


int AudioDeviceConfig::getAutoClose() {
  return (int)autoCloseBox->isChecked();
}

int AudioDeviceConfig::getAutoInit() {
  return (int)overrideBox->isChecked();
}

int AudioDeviceConfig::getSampleSize() {
  return sssBox->getSampleSize();
}


int AudioDeviceConfig::getSampleFreq() {
  return sssBox->getSampleFreq();
}

int AudioDeviceConfig::getStereo() {
  return sssBox->getStereo();
}
 

void AudioDeviceConfig::autoInitToggle() {
  int check=overrideBox->isChecked();
  if (check) {
    sssBox->setEnabled(false);
  } else {
    sssBox->setEnabled(true);
  }
}


