
// include files for Qt
#include <qdir.h>
#include <qwidget.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>

// application specific includes
#include "kmp3dbdoc.h"
#include "kmp3db.h"
#include "kmp3dbview.h"

QList<Kmp3dbView> *Kmp3dbDoc::pViewList = 0L;

Kmp3dbDoc::Kmp3dbDoc(QWidget *parent, const char *name) : QObject(parent, name)
{
  if(!pViewList)
  {
    pViewList = new QList<Kmp3dbView>();
  }

  pViewList->setAutoDelete(true);
}

Kmp3dbDoc::~Kmp3dbDoc()
{
}

void Kmp3dbDoc::addView(Kmp3dbView *view)
{
  pViewList->append(view);
}

void Kmp3dbDoc::removeView(Kmp3dbView *view)
{
  pViewList->remove(view);
}
void Kmp3dbDoc::setURL(const KURL &url)
{
  doc_url=url;
}

const KURL& Kmp3dbDoc::URL() const
{
  return doc_url;
}

void Kmp3dbDoc::slotUpdateAllViews(Kmp3dbView *sender)
{
  Kmp3dbView *w;
  if(pViewList)
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
      if(w!=sender)
        w->repaint();
    }
  }

}

bool Kmp3dbDoc::saveModified()
{
  bool completed=true;

  if(modified)
  {
    Kmp3dbApp *win=(Kmp3dbApp *) parent();
    int want_save = KMessageBox::warningYesNoCancel(win, i18n("Warning"),
                                         i18n("The current file has been modified.\n"
                                              "Do you want to save it?"));
    switch(want_save)
    {
      case 1:
           if (doc_url.fileName() == i18n("Untitled"))
           {
             win->slotFileSaveAs();
           }
           else
           {
             saveDocument(URL());
       	   };

       	   deleteContents();
           completed=true;
           break;

      case 2:
           setModified(false);
           deleteContents();
           completed=true;
           break;	

      case 3:
           completed=false;
           break;

      default:
           completed=false;
           break;
    }
  }

  return completed;
}

void Kmp3dbDoc::closeDocument()
{
  deleteContents();
}

bool Kmp3dbDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  modified=false;
  doc_url.setFileName(i18n("Untitled"));

  return true;
}

bool Kmp3dbDoc::openDocument(const KURL& url, const char *format /*=0*/)
{
  QString tmpfile;
  KIO::NetAccess::download( url, tmpfile );
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  /////////////////////////////////////////////////

  KIO::NetAccess::removeTempFile( tmpfile );

  modified=false;
  return true;
}

bool Kmp3dbDoc::saveDocument(const KURL& url, const char *format /*=0*/)
{
  /////////////////////////////////////////////////
  // TODO: Add your document saving code here
  /////////////////////////////////////////////////

  modified=false;
  return true;
}

void Kmp3dbDoc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////

}
