/***************************************************************************
                          dirview.h  -  description                              
                             -------------------                                         
    begin                : Sun Mar 5 2000                                           
    copyright            : (C) 2000 by Edwin Schepers                         
    email                : zeus@castel.nl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DIRVIEW_H
#define DIRVIEW_H

//#include <qlistviewitem.h>
#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtimer.h>

/**
  *@author Edwin Schepers
  */

class Directory : public QListViewItem  {
public: 
	Directory( QListView * parent, const QString& filename);
  Directory( Directory * parent, const QString& filename );
	~Directory();

  QString text1( int column ) const;

    QString fullName();

    void setOpen( bool );
    void setup();

private:
    QFile f;
    Directory * p;
    bool readable;
    bool showDirsOnly;
};

class DirectoryView : public QListView
{
    Q_OBJECT

public:
    DirectoryView( QWidget *parent = 0, const char *name = 0, bool sdo = FALSE );
    bool showDirsOnly() { return dirsOnly; }

signals:
    void folderSelected( const QString & );

protected slots:
    void slotFolderSelected( QListViewItem * );
    void openFolder();

protected:
//    void contentsDragEnterEvent( QDragEnterEvent *e );
//    void contentsDragMoveEvent( QDragMoveEvent *e );
//    void contentsDragLeaveEvent( QDragLeaveEvent *e );
//    void contentsDropEvent( QDropEvent *e );
//    void contentsMouseMoveEvent( QMouseEvent *e );
    void contentsMousePressEvent( QMouseEvent *e );
    void contentsMouseReleaseEvent( QMouseEvent *e );

private:
    QString fullPath(QListViewItem* item);
    bool dirsOnly;
    QListViewItem *oldCurrent;
    QListViewItem *dropItem;
    QTimer autoopen_timer;
    QPoint presspos;
    bool mousePressed;

    // ############# Move this to QScrollView
private:
    QTimer autoscroll_timer;
    int autoscroll_time;
    int autoscroll_accel;
public slots:
    void startAutoScroll();
    void stopAutoScroll();
protected slots:
    void autoScroll();
};









#endif





