/*	MikMod sound library
	(c) 1998, 1999 Miodrag Vallat and others - see file AUTHORS for
	complete list.

	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <errno.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#include <stdlib.h>
#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif
#ifdef __FreeBSD__
#include <machine/soundcard.h>
#else 
#include <sys/soundcard.h>
#endif

#include <mikmod_internals.h>

/* compatibility with very, very old versions of OSS */
#ifndef AFMT_S16_LE
#define AFMT_S16_LE (16)
#endif
#ifndef AFMT_U8
#define AFMT_U8 (8)
#endif

#define DEFAULT_FRAGSIZE 17
#define DEFAULT_NUMFRAGS 4

static	int sndfd=-1;
static	int fragmentsize;
static	SBYTE *audiobuffer=NULL;

/*
New stuff starts here
*/
/*
#define MIKMOD_DEBUG
*/
/*#define BUFLEN 65536*/
#define BLOCKS 8192
#define MIN(x,y) (x)<(y)?(x):(y)
enum {FALSE=0, TRUE};

static UWORD	BUFLEN	 = 0;		/* lenght of threaded buffer */
static SBYTE 	*buffer	 = NULL;        /* threaded buffer */
static BOOL	going	 = FALSE;	/* driver alive */
static UWORD	rd_index = 0,		/* reader index (read from buffer) */
		wr_index = 0,		/* writer index (write to buffer) */
		full	 = 0;		/* bytes in buffer */

static pthread_mutex_t	buffer_lock;	/* buffer lock */
static pthread_t	buffer_thread;	/* buffer thread */

static int buffer_free (void)
{
	return BUFLEN-full;
}

static void buffer_write (void *ptr, int length)
{
	pthread_mutex_lock(&buffer_lock);
	memcpy(buffer+wr_index, ptr, length);
	full += length;
	wr_index = (wr_index+length)%BUFLEN;
	pthread_mutex_unlock(&buffer_lock);
}

static void *buffer_loop (void *p)
{
	audio_buf_info buf_info;
	unsigned int cnt=0, wrote=0;
#ifdef MIKMOD_DEBUG
	unsigned int starving=0;
	fprintf(stderr,"buffer_loop started, ID: %i\n", getpid());
#endif
	while (going) {
		pthread_mutex_unlock(&buffer_lock);
		usleep(10000);
		pthread_mutex_lock(&buffer_lock);
		if (full) {
			cnt = MIN(full, (BUFLEN-rd_index));
			wrote = MIN(cnt, fragmentsize);
			ioctl(sndfd, SNDCTL_DSP_GETOSPACE, &buf_info);
			if(wrote && buf_info.bytes >= wrote) {
				write(sndfd, buffer+rd_index, wrote);
				rd_index = (rd_index+wrote)%BUFLEN;
				full -= wrote;
				continue;
			}
		} else {
			rd_index = wr_index = 0;
			ioctl(sndfd,SNDCTL_DSP_POST,0);
#ifdef MIKMOD_DEBUG
			fprintf (stderr,"starving: %i\r", ++starving);
#endif
		}
	}
#ifdef MIKMOD_DEBUG
	fprintf(stderr,"buffer_loop exiting\n");
#endif
	pthread_exit(NULL);
}

static BOOL OSS_IsThere(void)
{
	/* under Linux, and perhaps other Unixes, access()ing the device is not
	   enough since it won't fail if the machine doesn't have sound support
	   in the kernel or sound hardware                                      */
	int fd;

	if((fd=open("/dev/dsp",O_WRONLY))>0) {
		close(fd);
		return 1;
	}
	return (errno==EACCES?1:0);
}

static BOOL OSS_Init_internal(void)
{
	int play_precision,play_stereo,play_rate;
	int orig_precision,orig_stereo,orig_rate;

	orig_precision=play_precision=(md_mode&DMODE_16BITS)?AFMT_S16_LE:AFMT_U8;
	orig_stereo=play_stereo=(md_mode&DMODE_STEREO)?1:0;
	orig_rate=play_rate=md_mixfreq;

	if((ioctl(sndfd,SNDCTL_DSP_SAMPLESIZE,&play_precision)<0)||
	   (orig_precision!=play_precision)) {
		_mm_errno=MMERR_OSS_SETSAMPLESIZE;
		return 1;
	}
	if((ioctl(sndfd,SNDCTL_DSP_STEREO,&play_stereo)<0)||
	   (orig_stereo!=play_stereo)) {
		_mm_errno=MMERR_OSS_SETSTEREO;
		return 1;
	}
	if((ioctl(sndfd,SNDCTL_DSP_SPEED,&play_rate)<0)) {
		_mm_errno=MMERR_OSS_SETSPEED;
		return 1;
	}
/*	ioctl(sndfd,SNDCTL_DSP_PROFILE,APF_CPUINTENS);
*/	
	/* if(orig_rate!=play_rate) */
		md_mixfreq=play_rate;

	ioctl(sndfd,SNDCTL_DSP_GETBLKSIZE,&fragmentsize);
	if(!(audiobuffer=(SBYTE*)_mm_malloc(fragmentsize)))
		return 1;

	BUFLEN = fragmentsize + (fragmentsize/2);
	rd_index = wr_index = full = 0;
	buffer = (SBYTE *)_mm_malloc(BUFLEN+1);
	pthread_mutex_init(&buffer_lock, NULL);
	going = TRUE;
	pthread_create(&buffer_thread, NULL, buffer_loop, NULL);
#ifdef MIKMOD_DEBUG
	fprintf(stderr,"fragmentsize: %i\n", fragmentsize);
#endif

	return VC_Init();
}

static BOOL OSS_Init(void)
{
	char *env;
	int fragsize,numfrags;
	
	if((sndfd=open("/dev/dsp",O_WRONLY))<0) {
		_mm_errno=MMERR_OPENING_AUDIO;
		return 1;
	}

	fragsize=(env=getenv("MM_FRAGSIZE"))?atoi(env):DEFAULT_FRAGSIZE;
	numfrags=(env=getenv("MM_NUMFRAGS"))?atoi(env):DEFAULT_NUMFRAGS;
		
	if(fragsize<7||fragsize>17) fragsize=DEFAULT_FRAGSIZE;
	if(numfrags<2||numfrags>255) numfrags=DEFAULT_NUMFRAGS;

	fragmentsize=(numfrags<<16)|fragsize;
	
	if(ioctl(sndfd,SNDCTL_DSP_SETFRAGMENT,&fragmentsize)<0) {
		_mm_errno=MMERR_OSS_SETFRAGMENT;
		return 1;
	}
	fragmentsize=fragsize;

	return OSS_Init_internal();
}

static void OSS_Exit_internal(void)
{
	VC_Exit();
	if (audiobuffer) {
		free(audiobuffer);
		audiobuffer=NULL;
	}
	going=FALSE;
	pthread_join(buffer_thread, NULL);
	pthread_mutex_destroy(&buffer_lock);
	if (buffer) free (buffer);
}

static void OSS_Exit(void)
{
	OSS_Exit_internal();

	if (sndfd>=0) {
		close(sndfd);
		sndfd=-1;
	}
}

static void OSS_PlayStop(void)
{
	VC_PlayStop();

	memset(buffer, 0, BUFLEN);
	wr_index=rd_index=full=0;
}

static void OSS_Update(void)
{
	int free, write;
#ifdef MIKMOD_DEBUG
	static int doit=1;
	if (doit) {
		fprintf(stderr, "Update ID: %i\n", getpid());
		doit=0;
	}
#endif
	free=buffer_free();
	write=MIN(free, BLOCKS);
	
	if(write)
		buffer_write(audiobuffer,VC_WriteBytes(audiobuffer,write));
}

static BOOL OSS_Reset(void)
{
	OSS_Exit_internal();
	ioctl(sndfd,SNDCTL_DSP_RESET);
	return OSS_Init_internal();
}

MDRIVER drv_ossthr={
	NULL,
	"Open Sound System (OSS/Thr)",
	"Open Sound System (OSS/Thr) driver v0.3",
	0,255,
	OSS_IsThere,
	VC_SampleLoad,
	VC_SampleUnload,
	VC_SampleSpace,
	VC_SampleLength,
	OSS_Init,
	OSS_Exit,
	OSS_Reset,
	VC_SetNumVoices,
	VC_PlayStart,
	OSS_PlayStop,
	OSS_Update,
	NULL,
	VC_VoiceSetVolume,
	VC_VoiceGetVolume,
	VC_VoiceSetFrequency,
	VC_VoiceGetFrequency,
	VC_VoiceSetPanning,
	VC_VoiceGetPanning,
	VC_VoicePlay,
	VC_VoiceStop,
	VC_VoiceStopped,
	VC_VoiceGetPosition,
	VC_VoiceRealVolume
};

/* ex:set ts=4: */
