/*
 *	      PlayList - playlist dialog for kmikmod
 *	(C)1998, 1999 Roope Anttinen - roope.anttinen@ntc.nokia.com
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef _PlayList_H
#define _PlayList_H

#ifndef _MIT_POSIX_THREADS
# define _MIT_POSIX_THREADS
#endif
#ifndef _REENTRANT
# define _REENTRANT
#endif

#include <pthread.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qcheckbox.h>
#include <qlistview.h>
#include <qstring.h>
#include <drag.h>
#include <kfiledialog.h>
#define MAGIC "KMPLAYLIST 1.0"

// Playlist header (version number)
struct pl_header {
	char magic[16];
	char title[32];
};

// Playlist item version 1.0
struct pl_item {
	char fileName[256];
	char songName[64];
	char typeInfo[64];
	short channels;
	uint fileSize;
	short relativeVolume;
	short relativeSpeed;
};

// Playlist node version 1.0
struct pl_node {
	int idx;
	pl_item *data;
	bool operator ==(const pl_node &);
	bool operator !=(const pl_node &p) {return !operator==(p);}
	bool operator <(const pl_node &);
	bool operator >(const pl_node &);
};

class PlayList:public QDialog
{
	Q_OBJECT
private:
	
	QListView *listbox;
	QPushButton *PB_ok, *PB_cancel, *PB_apply;
	QPushButton *PB_add, *PB_remove, *PB_load, *PB_save, *PB_clear;
	QCheckBox *TB_rand, *TB_loop;

	QString plDir;
	
	bool randomize;

	int item_count;
	int max_idx;
	
	virtual char *getType(const QString);	// Return type of item.
	virtual char *getInfo(const QString);	// Return item info.
	bool gotPLDir();			// PL Directory exists?
	bool createPLDir();			// Create PL Directory.
	void loadList(const char *list);	// Load playlist.
	void loadList(const QString &list) {
		loadList((const char *)list);
	}
	void saveList(const char *list);	// Save playlist.
	void saveList(const QString &list) {
		saveList((const char *)list);
	}

public:

	pthread_mutex_t PL;			// Playlist lock.
	PlayList(QWidget *parent = NULL, const char *name = NULL);
	virtual ~PlayList();

	virtual const char *getCurrent();	// Return selected item.
	virtual bool next();			// Move selection to next item.
	virtual bool previous();		// Move selection backwards.
	virtual void remove();			// Remove selected item.
	void emptyList();			// Empty playlist.
	virtual void addToList(const char *, const char *, const char *);
	virtual void addToList(const char *n) {
		addToList(n, getType(n), getInfo(n));
	}
	virtual bool empty() {return !item_count;} // Is list empty?
	virtual void setInfo(const char *);	// Set info on current item.
	virtual void setInfo(const QString &i) {
		setInfo((const char *)i);
	}
	virtual void setType(const char *);	// (Re)set module type info.
	virtual void setType(const QString &t) {
		setType((const char *)t);
	}
	virtual const int items() {		// How many items in playlist.
		return item_count;
	}
	virtual const int current();		// What's the IDX of current item.
	
public slots:
	virtual void Dropped (KDNDDropZone*);
	virtual void CB_ok();			// OK button clicked.
	virtual void CB_cancel();		// Cancel button clicked.
	virtual void CB_apply();		// Apply button clicked.
	virtual void CB_add();			// Add button clicked.
	virtual void CB_remove();		// Remove button clicked.
	virtual void CB_load();			// Load playlist from a file.
	virtual void CB_save();			// Save playlist to a file.
	virtual void CB_clear() {emptyList();}	// Empty the playlist.

signals:
	void applyClicked ();
	void itemsChanged ();		// Amount of items changed.
};

#endif // _PlayList_H
