/*
  implements a blocking file descriptor
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __FIFO_H
#define __FIFO_H

#include <pthread.h>

#include <iostream.h>
#include <yafcore/buffer.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <sys/un.h>
#include <iostream.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>


#define _TIMEOUT_MS    100

class BindSocket {

  int bindSocket;
  int dataSocket;

  struct sockaddr_un sockad;
  struct sockaddr_un partn_ad;
  unsigned int partn_len;

  Buffer* buffer;
  
 public:
  BindSocket(char* filename);
  ~BindSocket();
  char* getSocketName();
  int isOpen();

  int read(char* buf, int max);
  int write(char* buf, int max);

  int accept();
  int bind();


 private:

};


#endif

