/*
  starts a new yafclient and stores the stdout,stdin,sterr channels
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __YAFCLIENT_H
#define __YAFCLIENT_H
#include <qstring.h>
#include <qobject.h>            // belongs to QT

#include <yafcore/buffer.h>
#include <yafcore/lineStack.h>
#include <yafcore/commandTable.h>

#include <util/controlChannel.h>
#include <util/outputDecoderBridge.h>
#include <yafcore/parser.h>
#include <yafcore/commandLine.h>
#include <yafcore/yafRuntime.defs>
#include <producer/yaf/yafMulticaster.h>

#include <signal/process/yafProcess.h>
#include <fstream.h>


#include <iostream.h>


extern "C" {
#include <string.h>
#include <stdio.h>
	   }


//#define _DEBUG_STDOUT
//#define _DEBUG_WRITE_STDIN


class YafClient : public QObject  {

  Q_OBJECT
 public:

  YafClient();
  virtual ~YafClient();


  int processRuntimeCommand(int command,char* args);
  int processReturnCommand(int cmdNr,int cmdId,char* ret,char* args);
  void addYafListener(ControlChannel* listener);
  void removeYafListener(ControlChannel* listener);
  
  // return the number attached for this command
  // (for return code filtering)
  virtual int send(char* msg);
  int createCommand(char* msg,Buffer* cmd);
  void rawSend(char* msg);

  void addArgument(char* arg);
  virtual void startDecoder();

  void appendCommandTable(CommandTable* table);
  void appendRuntimeTable(CommandTable* table);


  private slots:
    void receivedStdout(YafProcess *proc, char *buffer, int buflen);
    void receivedStderr(YafProcess *proc, char *buffer, int buflen);
    void processExited(YafProcess *proc);
    void wroteStdin(YafProcess *proc);

 private:

    void writeStdinToProcess(char* buf,int len);

    YafProcess* yafProcess;
    Buffer* tmpBuffer;
    Buffer* currentTransmitBuffer;
    int lSending;
    LineStack* inLineStack;
    LineStack* outLineStack;
    Parser* parser;
    int cmdNr;
    Buffer* msgBuffer;
    struct OutputDecoderBridge* outputDecoder;
    YafMulticaster* multicaster;

};

#endif


