/*
  A simple generator for images.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */






#ifndef __IMAGEGENERATOR_H
#define __IMAGEGENERATOR_H


#include <producer/core/dataGenerator.h>


// YAF should not depend on QT. But for this demonstration
// this is ok. But later the QT references are replaced
// with a yaf internal Image class!

#include <qpixmap.h>

/**
   This class produces QImages.
   You must open an image file. This file is internally stored.
   Then if the producer thread enters this class the
   internal QImage is cloned.
   <p>
   This class nows nothing about time. Thus if the thread enters
   more often that 25 time per second he can do this. But
   this consumes all cpu power.
   <p>
   The jump method is used to scroll the image up and down. It accepts
   percetn values.

*/


class ImageGenerator : public DataGenerator {

  // This is the internal image after "load"
  QPixmap* internal;

  // This is a copy of the internal image
  // This image can be scrolled up/down with jump
  QPixmap* cache;

  // This is the copy of the cache image
  // This image is delivered through the graph
  QPixmap* current;      

  DeviceConfig* config;
  StatusInfo* statusInfo;

  int scrollPos;
  int width;
  int height;
  int percent;

 public:
  ImageGenerator();
  ~ImageGenerator();

  int updateDeviceConfig(DeviceConfig* newConfig);

  int open(char* filename );
  int jump(int percent);


  void setThreadState(int state);
 private:
  void dataUpdate();
  

};

#endif
