/*
  mixes a DeviceConfigArray and delivers the result to the listeners
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __MIXERDEVICE_H
#define __MIXERDEVICE_H

#include <devices/multiInputDevice.h>
#include <filter/mixerFilter.h>
#include <filter/volumeFilter.h>

#define _MAX_PCM_BUFFER   16384

class MixerDevice : public MultiInputDevice {

  MemChunk* pcmChunk;
  DeviceConfig* config;
  DeviceConfigArray* configArray;
  MixerFilter* mixerFilter;
  VolumeFilter* volumeFilter;

 public:
  MixerDevice();
  ~MixerDevice();

  void writeOut(DeviceConfigArray* buf);
  
};
#endif

