/*
  works together with the deviceConfigServer <-> producer Interface
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __GENERICPLAYER_H
#define __GENERICPLAYER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <devices/streamProducer.h>
#include <producer/core/threadNotifier.h>
#include <producer/core/dataGenerator.h>
#include <deviceConfig/mem/garbageCollector.h>


#ifdef HAVE_SYS_ERRNO_H
#include <sys/errno.h>
#endif

#include <signal.h>

// events passed with "emit"
#define _GS_SIGNAL_PLAYING_READY     8

// events passed globally with the eventFilter mechanism
#define _GS_SIGNAL_GENERATOR_CRASHED  128


/**
   A GenericPlayer is more that a streamProducer,
   because it has open/close/jump...methods to controll the stream.
   This is the only device which really produces data. It
   creates a sperate thread for the data delivery and then waits
   for user commands.
   This device must be a root device, which means that you
   cannot write Data in it. You can only attach other
   nodeDevice to this device but no other Players itsself.
   <p>
   You attach a device to this player. Then if the thread has
   data to deliver, he writes it to this device. If you connect
   to the device other devices you can create complex graphs 
   of devices.
   <p>
   This allows to generate:
   <p>
   *trees of devices with a Player at the root
   <p>
   *directed device graphs (with Players as a
    node with none incoming edges, and n outgoing edges.)
   <p>
   The Player emits a _PLAYING_READY signal
   only if the playing stopps _without_ a user command.
   <p>
   The GENERATOR_CRASHED signal is emitted if the backend
   generator task has terminated. This is a workaround
   for buggy decoders.
*/


class GenericPlayer : public StreamProducer, ThreadNotifier{

  DeviceConfig* config;
  DataGenerator* generator;
  int lPlayOnOpen;
  int lOpenFile;
  StatusInfo* playerStatus;
  int lRunning;

 public:
  GenericPlayer();
  ~GenericPlayer();


  int open(const char* filename );
  int close();
  int play();
  int pause();
  int jump(int sec);

  int getPlayerStatus();     // returns the (global) state of the player

  int getPlayOnOpen();
  void setPlayOnOpen(int lPlayOnOpen);

  void setDataGenerator(DataGenerator* generator);
  DataGenerator* getDataGenerator();
  int isRunning();

  // from ThreadNotifier
  void sendSyncMessage(int lServerEnter);
  void writeOut(DeviceConfigArray* buf);
  char* getNodeName();

  // must be public because of thread! never do call directly!
  void writeloop();

  void dumpThread();

 private:
  void lockChangeMut();
  void unlockChangeMut();

  // _THREAD_DELIVER_THEN_SLEEP ,  _THREAD_SLEEP, _THREAD_DELIVER_
  int nThreadState;
  int lExit;

  // if we add a listener we first send him "stop"
  int lInitListener;

  Buffer* lastFileName;

  pthread_t tr;
  char* cThreadPos;

};
#endif
